/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class MatMultCP
extends Lop {
    private int numThreads = -1;
    private boolean isLeftTransposed;
    private boolean isRightTransposed;

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this(input1, input2, dt, vt, et, 1);
    }

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.MatMultCP, dt, vt);
        this.init(input1, input2, dt, vt, et);
        this.numThreads = k;
    }

    public MatMultCP(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean isLeftTransposed, boolean isRightTransposed) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, dt, vt, et);
        this.isLeftTransposed = isLeftTransposed;
        this.isRightTransposed = isRightTransposed;
    }

    private void init(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: ba+*";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        if (this.getExecType() == LopProperties.ExecType.CP) {
            return InstructionUtils.concatOperands(this.getExecType().name(), "ba+*", this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), String.valueOf(this.numThreads));
        }
        return InstructionUtils.concatOperands(this.getExecType().name(), "ba+*", this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), String.valueOf(this.numThreads), String.valueOf(this.isLeftTransposed), String.valueOf(this.isRightTransposed));
    }
}

