/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;

public class Compression
extends Lop {
    public static final String OPCODE = "compress";

    public Compression(Lop input, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.Checkpoint, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Compress";
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    public static enum CompressConfig {
        TRUE,
        FALSE,
        AUTO;


        public boolean isEnabled() {
            return this == TRUE || this == AUTO;
        }
    }
}

