/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.utils.Statistics;

public class FederatedRequest
implements Serializable {
    private static final long serialVersionUID = 5946781306963870394L;
    private RequestType _method;
    private long _id;
    private long _tid;
    private List<Object> _data;
    private boolean _checkPrivacy;

    public FederatedRequest(RequestType method) {
        this(method, FederationUtils.getNextFedDataID(), new ArrayList<Object>());
    }

    public FederatedRequest(RequestType method, long id) {
        this(method, id, new ArrayList<Object>());
    }

    public FederatedRequest(RequestType method, long id, Object ... data) {
        this(method, id, Arrays.asList(data));
    }

    public FederatedRequest(RequestType method, long id, List<Object> data) {
        Statistics.incFederated(method);
        this._method = method;
        this._id = id;
        this._data = data;
        this.setCheckPrivacy();
    }

    public RequestType getType() {
        return this._method;
    }

    public long getID() {
        return this._id;
    }

    public long getTID() {
        return this._tid;
    }

    public void setTID(long tid) {
        this._tid = tid;
    }

    public Object getParam(int i) {
        return this._data.get(i);
    }

    public FederatedRequest appendParam(Object obj) {
        this._data.add(obj);
        return this;
    }

    public FederatedRequest appendParams(Object ... objs) {
        this._data.addAll(Arrays.asList(objs));
        return this;
    }

    public int getNumParams() {
        return this._data.size();
    }

    public FederatedRequest deepClone() {
        return new FederatedRequest(this._method, this._id, new ArrayList<Object>(this._data));
    }

    public void setCheckPrivacy(boolean checkPrivacy) {
        this._checkPrivacy = checkPrivacy;
    }

    public void setCheckPrivacy() {
        this.setCheckPrivacy(DMLScript.CHECK_PRIVACY);
    }

    public boolean checkPrivacy() {
        return this._checkPrivacy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FederatedRequest[");
        sb.append((Object)this._method);
        sb.append(";");
        sb.append(this._id);
        sb.append(";");
        sb.append("t");
        sb.append(this._tid);
        sb.append(";");
        if (this._method != RequestType.PUT_VAR) {
            sb.append(Arrays.toString(this._data.toArray()));
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum RequestType {
        READ_VAR,
        PUT_VAR,
        GET_VAR,
        EXEC_INST,
        EXEC_UDF,
        CLEAR;

    }
}

