/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOffset;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupRLE
extends ColGroupOffset {
    private static final long serialVersionUID = 7450232907594748177L;

    protected ColGroupRLE() {
    }

    protected ColGroupRLE(int[] colIndices, int numRows, ABitmap ubm, CompressionSettings cs) {
        super(colIndices, numRows, ubm, cs);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int k = 0; k < numVals; ++k) {
            lbitmaps[k] = ColGroupRLE.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), ubm.getNumOffsets(k));
            totalLen += lbitmaps[k].length;
        }
        this.createCompressedBitmaps(numVals, totalLen, lbitmaps);
    }

    protected ColGroupRLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs) {
        super(colIndices, numRows, zeros, dict);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.RLE;
    }

    @Override
    protected ColGroup.ColGroupType getColGroupType() {
        return ColGroup.ColGroupType.RLE;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        if (this.getNumValues() > 1) {
            int blksz = 131072;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            double[] values = this.getValues();
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    int start = astart[k];
                    while (bix < blen & start < bimax) {
                        char len = this._data[boff + bix + 1];
                        for (int i = Math.max(rl, start += this._data[boff + bix]); i < Math.min(start + len, ru); ++i) {
                            for (int j = 0; j < numCols; ++j) {
                                if (values[off + j] == 0.0) continue;
                                target.appendValue(i, this._colIndexes[j], values[off + j]);
                            }
                        }
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, rl, ru);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colixTargets) {
        if (this.getNumValues() > 1) {
            int blksz = 131072;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            double[] values = this.getValues();
            int[] apos = new int[numVals];
            int[] astart = new int[numVals];
            int[] cix = new int[numCols];
            for (int j = 0; j < numCols; ++j) {
                cix[j] = colixTargets[this._colIndexes[j]];
            }
            for (int bi = 0; bi < this._numRows; bi += 131072) {
                int bimax = Math.min(bi + 131072, this._numRows);
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int start = astart[k];
                        while (bix < blen & start < bimax) {
                            char len = this._data[boff + bix + 1];
                            for (int i = start += this._data[boff + bix]; i < start + len; ++i) {
                                for (int j = 0; j < numCols; ++j) {
                                    if (values[off + j] == 0.0) continue;
                                    target.appendValue(i, cix[j], values[off + j]);
                                }
                            }
                            start += len;
                            bix += 2;
                        }
                        apos[k] = bix;
                        astart[k] = start;
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, colixTargets);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int blksz = 131072;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] c = target.getDenseBlockValues();
        double[] values = this.getValues();
        int[] astart = new int[numVals];
        int[] apos = ColGroupRLE.allocIVector(numVals, true);
        int nnz = 0;
        for (int bi = 0; bi < this._numRows; bi += 131072) {
            int bimax = Math.min(bi + 131072, this._numRows);
            Arrays.fill(c, bi, bimax, 0.0);
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int bix = apos[k];
                int blen = this.len(k);
                if (bix < blen) {
                    int start = astart[k];
                    while (bix < blen & start < bimax) {
                        char len = this._data[boff + bix + 1];
                        Arrays.fill(c, start += this._data[boff + bix], start + len, values[off + colpos]);
                        nnz += len;
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
                ++k;
                off += numCols;
            }
        }
        target.setNonZeros(nnz);
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunEnd = 0;
            int count = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                int curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                count += curRunEnd - curRunStartOff;
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows * this._colIndexes.length - sum;
        }
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
            int curRunStartOff = tmp.getValue();
            int curRunEnd = tmp.getValue();
            int count = 0;
            for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                count += Math.min(curRunEnd, ru) - curRunStartOff;
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = (ru - rl) * this._colIndexes.length - sum;
        }
        return counts;
    }

    @Override
    public void rightMultByVector(double[] b, double[] c, int rl, int ru, double[] dictVals) {
        int numVals = this.getNumValues();
        if (numVals >= 1 && this._numRows > 65536) {
            int blksz = 131072;
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            double[] aval = this.preaggValues(numVals, b, dictVals);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                for (int k = 0; k < numVals; ++k) {
                    int bix;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int start = astart[k];
                    for (bix = apos[k]; bix < blen; bix += 2) {
                        char lstart = this._data[boff + bix];
                        char llen = this._data[boff + bix + 1];
                        int len = Math.min(start + lstart + llen, bimax) - Math.max(bi, start + lstart);
                        if (len > 0) {
                            LinearAlgebraUtils.vectAdd(val, c, Math.max(bi, start + lstart), len);
                        }
                        if (start + lstart + llen >= bimax) break;
                        start += lstart + llen;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
        } else {
            block3: for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, b, dictVals);
                int start = 0;
                if (rl > 0) {
                    for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                        start += lstart + llen;
                    }
                }
                while (bix < blen) {
                    lstart = this._data[boff + bix];
                    llen = this._data[boff + bix + 1];
                    LinearAlgebraUtils.vectAdd(val, c, Math.max(rl, start + lstart), Math.min(start + lstart + llen, ru) - Math.max(rl, start + lstart));
                    if (start + lstart + llen >= ru) continue block3;
                    start += lstart + llen;
                    bix += 2;
                }
            }
        }
    }

    @Override
    public void rightMultByMatrix(double[] matrix, double[] result, int numVals, double[] values, int rl, int ru, int vOff) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public void leftMultByRowVector(double[] a, double[] c, int numVals) {
        numVals = numVals == -1 ? this.getNumValues() : numVals;
        double[] values = this.getValues();
        this.leftMultByRowVector(a, c, numVals, values);
    }

    @Override
    public void leftMultByRowVector(double[] a, double[] c, int numVals, double[] values) {
        int numCols = this.getNumCols();
        if (numVals >= 1 && this._numRows > 65536) {
            int blksz = 131072;
            int[] astart = new int[numVals];
            int[] apos = ColGroupRLE.allocIVector(numVals, true);
            double[] cvals = ColGroupRLE.allocDVector(numVals, true);
            for (int ai = 0; ai < this._numRows; ai += 131072) {
                int aimax = Math.min(ai + 131072, this._numRows);
                for (int k = 0; k < numVals; ++k) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    int start = astart[k];
                    while (bix < blen & start < aimax) {
                        char len = this._data[boff + bix + 1];
                        int n = k;
                        cvals[n] = cvals[n] + LinearAlgebraUtils.vectSum(a, start += this._data[boff + bix], len);
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                for (int j = 0; j < numCols; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + cvals[k] * values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        } else {
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double vsum = 0.0;
                int curRunEnd = 0;
                for (int bix = 0; bix < blen; bix += 2) {
                    int curRunStartOff = curRunEnd + this._data[boff + bix];
                    char curRunLen = this._data[boff + bix + 1];
                    vsum += LinearAlgebraUtils.vectSum(a, curRunStartOff, curRunLen);
                    curRunEnd = curRunStartOff + curRunLen;
                }
                for (int j = 0; j < numCols; ++j) {
                    int n = this._colIndexes[j];
                    c[n] = c[n] + vsum * values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        }
    }

    @Override
    public void leftMultByMatrix(double[] a, double[] c, int numVals, double[] values, int numRows, int numCols, int rl, int ru, int voff) {
        int thisNumCols = this.getNumCols();
        if (numVals >= 1 && this._numRows > 65536) {
            int blksz = 131072;
            int[] astart = new int[numVals];
            int i = rl;
            int off = voff * this._numRows;
            while (i < ru) {
                int[] apos = ColGroupRLE.allocIVector(numVals, true);
                double[] cvals = ColGroupRLE.allocDVector(numVals, true);
                for (int ai = 0; ai < this._numRows; ai += 131072) {
                    int aimax = Math.min(ai + 131072, this._numRows);
                    for (int k = 0; k < numVals; ++k) {
                        int boff = this._ptr[k];
                        int blen = this.len(k);
                        int bix = apos[k];
                        int start = astart[k];
                        while (bix < blen & start + off < aimax) {
                            char len = this._data[boff + bix + 1];
                            int n = k;
                            cvals[n] = cvals[n] + LinearAlgebraUtils.vectSum(a, (start += this._data[boff + bix]) + off, len);
                            start += len;
                            bix += 2;
                        }
                        apos[k] = bix;
                        astart[k] = start;
                    }
                }
                int k = 0;
                int valOff = 0;
                while (k < numVals) {
                    for (int j = 0; j < thisNumCols; ++j) {
                        int colIx;
                        int n = colIx = this._colIndexes[j] + i * numCols;
                        c[n] = c[n] + cvals[k] * values[valOff + j];
                    }
                    ++k;
                    valOff += thisNumCols;
                }
                ++i;
                off += this._numRows;
            }
        } else {
            int i = rl;
            int off = voff * this._numRows;
            while (i < ru) {
                int k = 0;
                int valOff = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double vsum = 0.0;
                    int curRunEnd = 0;
                    for (int bix = 0; bix < blen; bix += 2) {
                        int curRunStartOff = curRunEnd + this._data[boff + bix];
                        char curRunLen = this._data[boff + bix + 1];
                        vsum += LinearAlgebraUtils.vectSum(a, curRunStartOff + off, curRunLen);
                        curRunEnd = curRunStartOff + curRunLen;
                    }
                    for (int j = 0; j < thisNumCols; ++j) {
                        int colIx;
                        int n = colIx = this._colIndexes[j] + i * numCols;
                        c[n] = c[n] + vsum * values[valOff + j];
                    }
                    ++k;
                    valOff += thisNumCols;
                }
                ++i;
                off += this._numRows;
            }
        }
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupRLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr);
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, false, this.applyScalarOp(op), this._data, this._ptr);
        }
        ADictionary rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = ColGroupRLE.genRLEBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupRLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs);
    }

    @Override
    protected final void computeSum(double[] c, KahanFunction kplus) {
        c[0] = c[0] + this._dict.sum(this.getCounts(), this._colIndexes.length, kplus);
    }

    @Override
    protected final void computeRowSums(double[] c, KahanFunction kplus, int rl, int ru, boolean mean) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        int numVals = this.getNumValues();
        if (numVals > 1 && this._numRows > 65536) {
            int blksz = 65536;
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            double[] aval = this._dict.sumAllRowsToDouble(kplus, kbuff, this._colIndexes.length);
            for (int bi = rl; bi < ru; bi += 65536) {
                int bimax = Math.min(bi + 65536, ru);
                for (int k = 0; k < numVals; ++k) {
                    int bix;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int start = astart[k];
                    for (bix = apos[k]; bix < blen; bix += 2) {
                        char lstart = this._data[boff + bix];
                        char llen = this._data[boff + bix + 1];
                        int from = Math.max(bi, start + lstart);
                        int to = Math.min(start + lstart + llen, bimax);
                        for (int rix = from; rix < to; ++rix) {
                            this.setandExecute(c, kbuff, kplus2, val, rix * (2 + (mean ? 1 : 0)));
                        }
                        if (start + lstart + llen >= bimax) break;
                        start += lstart + llen;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this._dict.sumRow(k, kplus, kbuff, this._colIndexes.length);
                if (val == 0.0) continue;
                Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
                int curRunStartOff = tmp.getValue();
                int curRunEnd = tmp.getValue();
                for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                    curRunStartOff = curRunEnd + this._data[boff + bix];
                    curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                    for (int rix = curRunStartOff; rix < curRunEnd && rix < ru; ++rix) {
                        this.setandExecute(c, kbuff, kplus2, val, rix * (2 + (mean ? 1 : 0)));
                    }
                }
            }
        }
    }

    @Override
    protected final void computeColSums(double[] c, KahanFunction kplus) {
        this._dict.colSum(c, this.getCounts(), this._colIndexes, kplus);
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin, values);
            Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
            int curRunStartOff = tmp.getValue();
            int curRunEnd = tmp.getValue();
            for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int rix = curRunStartOff; rix < curRunEnd && rix < ru; ++rix) {
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    public boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                Arrays.fill(ret, curRunStartOff, curRunEnd, false);
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] astart = new int[numVals];
        int[] apos = this.skipScan(numVals, rl, astart);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = apos[k]; bix < blen && curRunStartOff < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int i = Math.max(curRunStartOff, rl); i < Math.min(curRunEnd, ru); ++i) {
                    int n = i - rl;
                    rnnz[n] = rnnz[n] + numCols;
                }
            }
        }
    }

    private int[] skipScan(int numVals, int rl, int[] astart) {
        int[] apos = ColGroupRLE.allocIVector(numVals, rl == 0);
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                    start += lstart + llen;
                }
                apos[k] = bix;
                astart[k] = start;
            }
        }
        return apos;
    }

    private Pair<Integer, Integer> skipScanVal(int k, int rl) {
        int apos = 0;
        int astart = 0;
        if (rl > 0) {
            char llen;
            char lstart;
            int bix;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = 0;
            for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                start += lstart + llen;
            }
            apos = bix;
            astart = start;
        }
        return new Pair<Integer, Integer>(apos, astart);
    }

    @Override
    public Iterator<Integer> getIterator(int k) {
        return new RLEValueIterator(k, 0, this._numRows);
    }

    @Override
    public Iterator<Integer> getIterator(int k, int rl, int ru) {
        return new RLEValueIterator(k, rl, ru);
    }

    @Override
    public ColGroup.ColGroupRowIterator getRowIterator(int rl, int ru) {
        return new RLERowIterator(rl, ru);
    }

    public static char[] genRLEBitmap(int[] offsets, int len) {
        ArrayList<Character> buf = new ArrayList<Character>();
        int lastRunEnd = 0;
        int curRunLen = 0;
        int firstOff = offsets[0];
        while (firstOff > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            firstOff -= 65535;
            lastRunEnd += 65535;
        }
        int curRunOff = firstOff;
        curRunLen = 1;
        for (int i = 1; i < len; ++i) {
            int absOffset = offsets[i];
            int curRunEnd = lastRunEnd + curRunOff + curRunLen;
            if (absOffset > curRunEnd || curRunLen >= 65535) {
                buf.add(Character.valueOf((char)curRunOff));
                buf.add(Character.valueOf((char)curRunLen));
                lastRunEnd = curRunEnd;
                for (curRunOff = absOffset - lastRunEnd; curRunOff > 65535; curRunOff -= 65535) {
                    buf.add(Character.valueOf('\uffff'));
                    buf.add(Character.valueOf('\u0000'));
                    lastRunEnd += 65535;
                }
                curRunLen = 1;
                continue;
            }
            ++curRunLen;
        }
        if (curRunOff + curRunLen > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            curRunOff -= 65535;
        }
        buf.add(Character.valueOf((char)curRunOff));
        buf.add(Character.valueOf((char)curRunLen));
        char[] ret = new char[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = ((Character)buf.get(i)).charValue();
        }
        return ret;
    }

    private class RLERowIterator
    extends ColGroup.ColGroupRowIterator {
        private final int[] _astart;
        private final int[] _apos;
        private final int[] _vcodes;

        public RLERowIterator(int rl, int ru) {
            super(ColGroupRLE.this);
            this._astart = new int[ColGroupRLE.this.getNumValues()];
            this._apos = ColGroupRLE.this.skipScan(ColGroupRLE.this.getNumValues(), rl, this._astart);
            this._vcodes = new int[Math.min(65536, ru - rl)];
            Arrays.fill(this._vcodes, -1);
            this.getNextSegment(rl);
        }

        @Override
        public void next(double[] buff, int rowIx, int segIx, boolean last) {
            int clen = ColGroupRLE.this.getNumCols();
            int vcode = this._vcodes[segIx];
            if (vcode >= 0) {
                double[] values = ColGroupRLE.this.getValues();
                int off = vcode * clen;
                for (int j = 0; j < clen; ++j) {
                    buff[ColGroupRLE.this._colIndexes[j]] = values[off + j];
                }
                this._vcodes[segIx] = -1;
            }
            if (segIx + 1 == 65536 && !last) {
                this.getNextSegment(rowIx + 1);
            }
        }

        private void getNextSegment(int rowIx) {
            int numVals = ColGroupRLE.this.getNumValues();
            int blksz = 65536;
            for (int k = 0; k < numVals; ++k) {
                int start;
                char llen;
                char lstart;
                int boff = ColGroupRLE.this._ptr[k];
                int blen = ColGroupRLE.this.len(k);
                int bix = this._apos[k];
                int end = (rowIx / 65536 + 1) * 65536;
                for (start = this._astart[k]; bix < blen && start < end; start += lstart + llen, bix += 2) {
                    lstart = ColGroupRLE.this._data[boff + bix];
                    llen = ColGroupRLE.this._data[boff + bix + 1];
                    Arrays.fill(this._vcodes, Math.min(Math.max(rowIx, start + lstart), end) - rowIx, Math.min(start + lstart + llen, end) - rowIx, k);
                    if (start + lstart + llen >= end) break;
                }
                this._apos[k] = bix;
                this._astart[k] = start;
            }
        }
    }

    private class RLEValueIterator
    implements Iterator<Integer> {
        private final int _ru;
        private final int _boff;
        private final int _blen;
        private int _bix;
        private int _start;
        private int _rpos;

        public RLEValueIterator(int k, int rl, int ru) {
            this._ru = ru;
            this._boff = ColGroupRLE.this._ptr[k];
            this._blen = ColGroupRLE.this.len(k);
            this._bix = 0;
            this._start = 0;
            this._rpos = ColGroupRLE.this._data[this._boff + this._bix];
            while (this._rpos < rl) {
                this.nextRowOffset();
            }
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more RLE entries.");
            }
            int ret = this._rpos;
            this.nextRowOffset();
            return ret;
        }

        private void nextRowOffset() {
            if (!this.hasNext()) {
                return;
            }
            char lstart = ColGroupRLE.this._data[this._boff + this._bix];
            char llen = ColGroupRLE.this._data[this._boff + this._bix + 1];
            if (this._rpos - this._start - lstart + 1 >= llen) {
                this._start += lstart + llen;
                this._bix += 2;
                this._rpos = this._bix >= this._blen ? this._ru : this._start + ColGroupRLE.this._data[this._boff + this._bix];
            } else {
                ++this._rpos;
            }
        }
    }
}

