/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.dl;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.sysml.api.dl.Caffe2DML;
import org.apache.sysml.api.dl.Caffe2DMLModel;
import org.apache.sysml.api.dl.Utils$;
import org.apache.sysml.api.mlcontext.Script;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;

public final class Caffe2DML$
implements Serializable {
    public static final Caffe2DML$ MODULE$;
    private final Log LOG;
    private final boolean USE_PLUS_EQ;
    private final String X;
    private final String y;
    private final String batchSize;
    private final String numImages;
    private final String numValidationImages;
    private final String XVal;
    private final String yVal;
    private final boolean USE_NESTEROV_UDF;
    private final Random rand;
    private final String MINIBATCH_ALGORITHM;
    private final String BATCH_ALGORITHM;
    private final String ALLREDUCE_ALGORITHM;
    private final String ALLREDUCE_PARALLEL_BATCHES_ALGORITHM;

    static {
        new Caffe2DML$();
    }

    public Log LOG() {
        return this.LOG;
    }

    public boolean USE_PLUS_EQ() {
        return this.USE_PLUS_EQ;
    }

    public String layerDir() {
        return "nn/layers/";
    }

    public String optimDir() {
        return "nn/optim/";
    }

    public String X() {
        return this.X;
    }

    public String y() {
        return this.y;
    }

    public String batchSize() {
        return this.batchSize;
    }

    public String numImages() {
        return this.numImages;
    }

    public String numValidationImages() {
        return this.numValidationImages;
    }

    public String XVal() {
        return this.XVal;
    }

    public String yVal() {
        return this.yVal;
    }

    public boolean USE_NESTEROV_UDF() {
        return this.USE_NESTEROV_UDF;
    }

    public void main(String[] args) {
        if (args.length < 6) {
            this.throwUsageError();
        }
        String outputDMLFile = args[1];
        String solverFile = args[2];
        String inputChannels = args[3];
        String inputHeight = args[4];
        String inputWidth = args[5];
        Caffe2DML caffeObj = new Caffe2DML(new SparkContext(), solverFile, inputChannels, inputHeight, inputWidth);
        if (args[0].equals("train_script")) {
            Utils$.MODULE$.writeToFile(((Script)caffeObj.getTrainingScript(true)._1()).getScriptString(), outputDMLFile);
        } else if (args[0].equals("predict_script")) {
            Utils$.MODULE$.writeToFile(((Script)new Caffe2DMLModel(caffeObj).getPredictionScript(true)._1()).getScriptString(), outputDMLFile);
        } else {
            this.throwUsageError();
        }
    }

    public void throwUsageError() {
        throw new RuntimeException("Incorrect usage: train_script OUTPUT_DML_FILE SOLVER_FILE INPUT_CHANNELS INPUT_HEIGHT INPUT_WIDTH");
    }

    public Random rand() {
        return this.rand;
    }

    public String MINIBATCH_ALGORITHM() {
        return this.MINIBATCH_ALGORITHM;
    }

    public String BATCH_ALGORITHM() {
        return this.BATCH_ALGORITHM;
    }

    public String ALLREDUCE_ALGORITHM() {
        return this.ALLREDUCE_ALGORITHM;
    }

    public String ALLREDUCE_PARALLEL_BATCHES_ALGORITHM() {
        return this.ALLREDUCE_PARALLEL_BATCHES_ALGORITHM;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Caffe2DML$() {
        MODULE$ = this;
        this.LOG = LogFactory.getLog((String)Caffe2DML.class.getName());
        this.USE_PLUS_EQ = true;
        this.X = "X";
        this.y = "y";
        this.batchSize = "BATCH_SIZE";
        this.numImages = "num_images";
        this.numValidationImages = "num_validation";
        this.XVal = "X_val";
        this.yVal = "y_val";
        String envFlagNesterovUDF = System.getenv("USE_NESTEROV_UDF");
        this.USE_NESTEROV_UDF = envFlagNesterovUDF != null && new StringOps(Predef$.MODULE$.augmentString(envFlagNesterovUDF)).toBoolean();
        this.rand = new Random();
        this.MINIBATCH_ALGORITHM = "minibatch";
        this.BATCH_ALGORITHM = "batch";
        this.ALLREDUCE_ALGORITHM = "allreduce";
        this.ALLREDUCE_PARALLEL_BATCHES_ALGORITHM = "allreduce_parallel_batches";
    }
}

