/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;

public abstract class ResultMerge
implements Serializable {
    private static final long serialVersionUID = 2620430969346516677L;
    protected static final Log LOG = LogFactory.getLog(ResultMerge.class.getName());
    protected static final String NAME_SUFFIX = "_rm";
    protected static final BinaryOperator PLUS = InstructionUtils.parseBinaryOperator("+");
    protected MatrixObject _output = null;
    protected MatrixObject[] _inputs = null;
    protected String _outputFName = null;
    protected boolean _isAccum = false;

    protected ResultMerge() {
    }

    public ResultMerge(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        this._output = out;
        this._inputs = in;
        this._outputFName = outputFilename;
        this._isAccum = accum;
    }

    public abstract MatrixObject executeSerialMerge();

    public abstract MatrixObject executeParallelMerge(int var1);

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly) {
        this.mergeWithoutComp(out, in, appendOnly, false);
    }

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly, boolean par) {
        if (this._isAccum) {
            out.binaryOperationsInPlace(PLUS, in);
        } else {
            out.merge(in, appendOnly, par);
        }
    }

    protected void mergeWithComp(MatrixBlock out, MatrixBlock in, DenseBlock compare) {
        if (in.isEmptyBlock(false)) {
            if (this._isAccum) {
                return;
            }
            for (int i = 0; i < in.getNumRows(); ++i) {
                for (int j = 0; j < in.getNumColumns(); ++j) {
                    if (compare.get(i, j) == 0.0) continue;
                    out.quickSetValue(i, j, 0.0);
                }
            }
        } else {
            int rows = in.getNumRows();
            int cols = in.getNumColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    double valOld = compare.get(i, j);
                    double valNew = in.quickGetValue(i, j);
                    if ((valNew == valOld || Double.isNaN(valNew)) && Double.isNaN(valNew) == Double.isNaN(valOld)) continue;
                    double value = !this._isAccum ? valNew : out.quickGetValue(i, j) + (valNew - valOld);
                    out.quickSetValue(i, j, value);
                }
            }
        }
    }

    protected long computeNonZeros(MatrixObject out, List<MatrixObject> in) {
        long outNNZ = out.getMatrixCharacteristics().getNonZeros();
        return outNNZ - (long)in.size() * outNNZ + in.stream().mapToLong(m -> m.getMatrixCharacteristics().getNonZeros()).sum();
    }
}

