/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.optim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.optim.adagrad.Update_output;

public class Adagrad
extends Script {
    public Adagrad() {
        String string = "scripts/nn/optim/adagrad.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix init(Object object) {
        String string = "source('scripts/nn/optim/adagrad.dml') as mlcontextns;cache = mlcontextns::init(X);";
        Script script = new Script(string);
        script.in("X", object).out("cache");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("cache");
        return matrix;
    }

    public String init__docs() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] cache) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(matrix[double] X)\n    return (matrix[double] cache) {\n  /*\n   * Initialize the state for this optimizer.\n   *\n   * Note: This is just a convenience function, and state\n   * may be initialized manually if needed.\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *\n   * Outputs:\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   */\n  cache = matrix(0, rows=nrow(X), cols=ncol(X))\n}\n";
        return string;
    }

    public Update_output update(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/optim/adagrad.dml') as mlcontextns;[X, cache] = mlcontextns::update(X, dX, lr, epsilon, cache);";
        Script script = new Script(string);
        script.in("X", object).in("dX", object2).in("lr", object3).in("epsilon", object4).in("cache", object5).out("X").out("cache");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Matrix matrix2 = mLResults.getMatrix("cache");
        Update_output update_output = new Update_output(matrix, matrix2);
        return update_output;
    }

    public String update__docs() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double epsilon,\n                  matrix[double] cache)\n    return (matrix[double] X, matrix[double] cache) {\n  /*\n   * Performs an Adagrad update.\n   *\n   * This is an adaptive learning rate optimizer that maintains the\n   * sum of squared gradients to automatically adjust the effective\n   * learning rate.\n   *\n   * Reference:\n   *  - Adaptive Subgradient Methods for Online Learning and Stochastic\n   *    Optimization, Duchi et al.\n   *      - http://jmlr.org/papers/v12/duchi11a.html\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-8, 1e-4].\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   */\n";
        return string;
    }

    public String update__source() {
        String string = "update = function(matrix[double] X, matrix[double] dX, double lr, double epsilon,\n                  matrix[double] cache)\n    return (matrix[double] X, matrix[double] cache) {\n  /*\n   * Performs an Adagrad update.\n   *\n   * This is an adaptive learning rate optimizer that maintains the\n   * sum of squared gradients to automatically adjust the effective\n   * learning rate.\n   *\n   * Reference:\n   *  - Adaptive Subgradient Methods for Online Learning and Stochastic\n   *    Optimization, Duchi et al.\n   *      - http://jmlr.org/papers/v12/duchi11a.html\n   *\n   * Inputs:\n   *  - X: Parameters to update, of shape (any, any).\n   *  - dX: Gradient wrt `X` of a loss function being optimized, of\n   *      same shape as `X`.\n   *  - lr: Learning rate.\n   *  - epsilon: Smoothing term to avoid divide by zero errors.\n   *      Typical values are in the range of [1e-8, 1e-4].\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   *\n   * Outputs:\n   *  - X: Updated parameters `X`, of same shape as input `X`.\n   *  - cache: State that maintains per-parameter sum of squared\n   *      gradients, of same shape as `X`.\n   */\n  cache = cache + dX^2\n  X = X - (lr * dX / (sqrt(cache)+epsilon))\n}\n";
        return string;
    }
}

