/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderOmit
extends Encoder {
    private static final long serialVersionUID = 1978852120416654195L;
    private int _rmRows = 0;

    public EncoderOmit(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        if (!parsedSpec.containsKey("omit")) {
            return;
        }
        int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "omit");
        this.initColList(collist);
    }

    public int getNumRemovedRows() {
        return this._rmRows;
    }

    public boolean omit(String[] words, TfUtils agents) {
        if (!this.isApplicable()) {
            return false;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            if (!TfUtils.isNA(agents.getNAStrings(), UtilFunctions.unquote(words[colID - 1].trim()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        int numRows = 0;
        for (int i = 0; i < out.getNumRows(); ++i) {
            boolean valid = true;
            for (int j = 0; j < this._colList.length; ++j) {
                valid &= !Double.isNaN(out.quickGetValue(i, this._colList[j] - 1));
            }
            numRows += valid ? 1 : 0;
        }
        MatrixBlock ret = new MatrixBlock(numRows, out.getNumColumns(), false);
        int pos = 0;
        for (int i = 0; i < in.getNumRows(); ++i) {
            int j;
            boolean valid = true;
            for (j = 0; j < this._colList.length; ++j) {
                valid &= !Double.isNaN(out.quickGetValue(i, this._colList[j] - 1));
            }
            if (!valid) continue;
            for (j = 0; j < out.getNumColumns(); ++j) {
                ret.quickSetValue(pos, j, out.quickGetValue(i, j));
            }
            ++pos;
        }
        this._rmRows = out.getNumRows() - pos;
        return ret;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }
}

