/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.jmx;

import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.axis2.AxisFault;
import org.apache.synapse.transport.passthru.PassThroughHttpListener;
import org.apache.synapse.transport.passthru.PassThroughHttpSender;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;
import org.apache.synapse.transport.passthru.jmx.TransportViewMBean;

public class TransportView
implements TransportViewMBean {
    private PassThroughHttpListener listener = null;
    private PassThroughHttpSender sender = null;
    private PassThroughTransportMetricsCollector metrics = null;
    private ThreadPoolExecutor threadPool = null;

    public TransportView(PassThroughHttpListener listener, PassThroughHttpSender sender, PassThroughTransportMetricsCollector metrics, ThreadPoolExecutor threadPool) throws AxisFault {
        this.listener = listener;
        this.metrics = metrics;
        this.threadPool = threadPool;
        this.sender = sender;
    }

    @Override
    public void pause() throws AxisFault {
        if (this.listener != null) {
            this.listener.pause();
        } else if (this.sender != null) {
            this.sender.pause();
        }
    }

    @Override
    public void resume() throws AxisFault {
        if (this.listener != null) {
            this.listener.resume();
        } else if (this.sender != null) {
            this.sender.resume();
        }
    }

    @Override
    public void maintenenceShutdown(long l) throws AxisFault {
        if (this.listener != null) {
            this.listener.maintenanceShutdown(l);
        } else if (this.sender != null) {
            this.sender.maintenanceShutdown(l);
        }
    }

    @Override
    public int getActiveThreadCount() {
        if (this.threadPool != null) {
            return this.threadPool.getActiveCount();
        }
        return 0;
    }

    @Override
    public int getQueueSize() {
        if (this.threadPool != null && this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().size();
        }
        return 0;
    }

    @Override
    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    @Override
    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    @Override
    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    @Override
    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    @Override
    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    @Override
    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    @Override
    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    @Override
    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    @Override
    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    @Override
    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    @Override
    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    @Override
    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    @Override
    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    @Override
    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    @Override
    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    @Override
    public void start() throws Exception {
        if (this.listener != null) {
            this.listener.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    @Override
    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    @Override
    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    @Override
    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }
}

