/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.mock.http.MockHttpInputMessage;
import org.springframework.util.Assert;

public class MockClientHttpResponse
extends MockHttpInputMessage
implements ClientHttpResponse {
    private final HttpStatusCode statusCode;

    public MockClientHttpResponse() {
        this(new byte[0], (HttpStatusCode)HttpStatus.OK);
    }

    public MockClientHttpResponse(byte[] body2, HttpStatusCode statusCode) {
        super(body2);
        Assert.notNull((Object)statusCode, (String)"HttpStatusCode must not be null");
        this.statusCode = statusCode;
    }

    public MockClientHttpResponse(byte[] body2, int statusCode) {
        this(body2, HttpStatusCode.valueOf((int)statusCode));
    }

    public MockClientHttpResponse(InputStream body2, HttpStatusCode statusCode) {
        super(body2);
        Assert.notNull((Object)statusCode, (String)"HttpStatusCode must not be null");
        this.statusCode = statusCode;
    }

    public MockClientHttpResponse(InputStream body2, int statusCode) {
        this(body2, HttpStatusCode.valueOf((int)statusCode));
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Deprecated
    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        String string;
        HttpStatusCode httpStatusCode = this.statusCode;
        if (httpStatusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)httpStatusCode;
            string = status.getReasonPhrase();
        } else {
            string = "";
        }
        return string;
    }

    public void close() {
        try {
            this.getBody().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

