/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.mapper.FlinkEnvMapper;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class FlinkEnvServiceImpl
extends ServiceImpl<FlinkEnvMapper, FlinkEnv>
implements FlinkEnvService {
    private static final Logger log = LoggerFactory.getLogger(FlinkEnvServiceImpl.class);

    @Override
    public boolean exists(FlinkEnv version) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(FlinkEnv::getFlinkName, (Object)version.getFlinkName());
        if (version.getId() != null) {
            queryWrapper.ne(FlinkEnv::getId, (Object)version.getId());
        }
        return this.count((Wrapper)queryWrapper) == 0L;
    }

    @Override
    public boolean create(FlinkEnv version) throws Exception {
        long count = ((FlinkEnvMapper)this.baseMapper).selectCount(null);
        version.setIsDefault(count == 0L);
        version.setCreateTime(new Date());
        version.doSetFlinkConf();
        version.doSetVersion();
        return this.save(version);
    }

    @Override
    public void update(FlinkEnv version) throws IOException {
        FlinkEnv flinkEnv = (FlinkEnv)super.getById((Serializable)version.getId());
        if (flinkEnv == null) {
            throw new RuntimeException("flink home message lost, please check database status!");
        }
        flinkEnv.setDescription(version.getDescription());
        flinkEnv.setFlinkName(version.getFlinkName());
        if (!version.getFlinkHome().equals(flinkEnv.getFlinkHome())) {
            flinkEnv.setFlinkHome(version.getFlinkHome());
            flinkEnv.doSetFlinkConf();
            flinkEnv.doSetVersion();
        }
        this.updateById(flinkEnv);
    }

    @Override
    public void setDefault(Long id) {
        ((FlinkEnvMapper)this.baseMapper).setDefault(id);
    }

    @Override
    public FlinkEnv getByAppId(Long appId) {
        return ((FlinkEnvMapper)this.baseMapper).getByAppId(appId);
    }

    @Override
    public FlinkEnv getDefault() {
        return (FlinkEnv)((FlinkEnvMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(FlinkEnv::getIsDefault, (Object)true));
    }

    @Override
    public FlinkEnv getByIdOrDefault(Long id) {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        if (flinkEnv == null) {
            return this.getDefault();
        }
        return flinkEnv;
    }

    @Override
    public void syncConf(Long id) throws IOException {
        FlinkEnv flinkEnv = (FlinkEnv)this.getById(id);
        flinkEnv.doSetFlinkConf();
        this.updateById(flinkEnv);
    }
}

