/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.util.CommandUtils;
import org.apache.streampark.console.base.exception.ApiDetailException;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.GitUtils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.enums.GitAuthorizedError;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_project")
public class Project
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Project.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long teamId;
    private String name;
    private String url;
    private String branches;
    private Date lastBuild;
    private Integer gitCredential;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String userName;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String password;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String prvkeyPath;
    private Integer repository;
    private String pom;
    private String buildArgs;
    private String description;
    private Integer buildState;
    private Integer type;
    private Date createTime;
    private Date modifyTime;
    private transient String module;
    private transient String dateFrom;
    private transient String dateTo;
    private transient String appSource;

    @JsonIgnore
    public File getAppSource() {
        File sourcePath;
        if (this.appSource == null) {
            this.appSource = Workspace.PROJECT_LOCAL_PATH();
        }
        if (!(sourcePath = new File(this.appSource)).exists()) {
            sourcePath.mkdirs();
        }
        if (sourcePath.isFile()) {
            throw new IllegalArgumentException("[StreamPark] sourcePath must be directory");
        }
        String branches = this.getBranches() == null ? "main" : this.getBranches();
        String rootName = this.url.replaceAll(".*/|\\.git|\\.svn", "");
        String fullName = rootName.concat("-").concat(branches);
        String path = String.format("%s/%s/%s", sourcePath.getAbsolutePath(), this.getName(), fullName);
        return new File(path);
    }

    @JsonIgnore
    public File getDistHome() {
        return new File(Workspace.APP_LOCAL_DIST(), this.id.toString());
    }

    @JsonIgnore
    public File getGitRepository() {
        File home = this.getAppSource();
        return new File(home, ".git");
    }

    public void delete() throws IOException {
        FileUtils.deleteDirectory((File)this.getAppSource());
        FileUtils.deleteDirectory((File)this.getDistHome());
    }

    @JsonIgnore
    public List<String> getAllBranches() {
        try {
            return GitUtils.getBranchList(this);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    public GitAuthorizedError gitCheck() {
        try {
            GitUtils.getBranchList(this);
            return GitAuthorizedError.SUCCESS;
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (err.contains("not authorized")) {
                return GitAuthorizedError.ERROR;
            }
            if (err.contains("Authentication is required")) {
                return GitAuthorizedError.REQUIRED;
            }
            return GitAuthorizedError.UNKNOW;
        }
    }

    @JsonIgnore
    public boolean isCloned() {
        File repository = this.getGitRepository();
        return repository.exists();
    }

    public void cleanCloned() throws IOException {
        if (this.isCloned()) {
            this.delete();
        }
    }

    @JsonIgnore
    public String getMavenArgs() {
        Setting setting;
        String mvn = "mvn";
        try {
            if (CommonUtils.isWindows()) {
                CommandUtils.execute((String)"mvn.cmd --version");
            } else {
                CommandUtils.execute((String)"mvn --version");
            }
        }
        catch (Exception e) {
            mvn = CommonUtils.isWindows() ? WebUtils.getAppHome().concat("/bin/mvnw.cmd") : WebUtils.getAppHome().concat("/bin/mvnw");
        }
        StringBuffer cmdBuffer = new StringBuffer(mvn).append(" clean package -DskipTests ");
        if (StringUtils.isNotEmpty((CharSequence)this.buildArgs)) {
            cmdBuffer.append(this.buildArgs.trim());
        }
        if ((setting = SettingService.SETTINGS.get(CommonConfig.MAVEN_SETTINGS_PATH())) != null) {
            cmdBuffer.append(" --settings ").append(setting.getSettingValue());
        }
        return cmdBuffer.toString();
    }

    @JsonIgnore
    public String getMavenWorkHome() {
        String buildHome = this.getAppSource().getAbsolutePath();
        if (CommonUtils.notEmpty(this.getPom()).booleanValue()) {
            buildHome = new File(buildHome.concat("/").concat(this.getPom())).getParentFile().getAbsolutePath();
        }
        return buildHome;
    }

    @JsonIgnore
    public String getLog4BuildStart() {
        return String.format("%sproject : %s\nbranches: %s\ncommand : %s\n\n", this.getLogHeader("maven install"), this.getName(), this.getBranches(), this.getMavenArgs());
    }

    @JsonIgnore
    public String getLog4CloneStart() {
        return String.format("%sproject  : %s\nbranches : %s\nworkspace: %s\n\n", this.getLogHeader("git clone"), this.getName(), this.getBranches(), this.getAppSource());
    }

    @JsonIgnore
    private String getLogHeader(String header) {
        return "---------------------------------[ " + header + " ]---------------------------------\n";
    }

    public Long getId() {
        return this.id;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranches() {
        return this.branches;
    }

    public Date getLastBuild() {
        return this.lastBuild;
    }

    public Integer getGitCredential() {
        return this.gitCredential;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrvkeyPath() {
        return this.prvkeyPath;
    }

    public Integer getRepository() {
        return this.repository;
    }

    public String getPom() {
        return this.pom;
    }

    public String getBuildArgs() {
        return this.buildArgs;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getBuildState() {
        return this.buildState;
    }

    public Integer getType() {
        return this.type;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getModule() {
        return this.module;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBranches(String branches) {
        this.branches = branches;
    }

    public void setLastBuild(Date lastBuild) {
        this.lastBuild = lastBuild;
    }

    public void setGitCredential(Integer gitCredential) {
        this.gitCredential = gitCredential;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPrvkeyPath(String prvkeyPath) {
        this.prvkeyPath = prvkeyPath;
    }

    public void setRepository(Integer repository) {
        this.repository = repository;
    }

    public void setPom(String pom) {
        this.pom = pom;
    }

    public void setBuildArgs(String buildArgs) {
        this.buildArgs = buildArgs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBuildState(Integer buildState) {
        this.buildState = buildState;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public void setAppSource(String appSource) {
        this.appSource = appSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$teamId = this.getTeamId();
        Long other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !((Object)this$teamId).equals(other$teamId)) {
            return false;
        }
        Integer this$gitCredential = this.getGitCredential();
        Integer other$gitCredential = other.getGitCredential();
        if (this$gitCredential == null ? other$gitCredential != null : !((Object)this$gitCredential).equals(other$gitCredential)) {
            return false;
        }
        Integer this$repository = this.getRepository();
        Integer other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        Integer this$buildState = this.getBuildState();
        Integer other$buildState = other.getBuildState();
        if (this$buildState == null ? other$buildState != null : !((Object)this$buildState).equals(other$buildState)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$branches = this.getBranches();
        String other$branches = other.getBranches();
        if (this$branches == null ? other$branches != null : !this$branches.equals(other$branches)) {
            return false;
        }
        Date this$lastBuild = this.getLastBuild();
        Date other$lastBuild = other.getLastBuild();
        if (this$lastBuild == null ? other$lastBuild != null : !((Object)this$lastBuild).equals(other$lastBuild)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$prvkeyPath = this.getPrvkeyPath();
        String other$prvkeyPath = other.getPrvkeyPath();
        if (this$prvkeyPath == null ? other$prvkeyPath != null : !this$prvkeyPath.equals(other$prvkeyPath)) {
            return false;
        }
        String this$pom = this.getPom();
        String other$pom = other.getPom();
        if (this$pom == null ? other$pom != null : !this$pom.equals(other$pom)) {
            return false;
        }
        String this$buildArgs = this.getBuildArgs();
        String other$buildArgs = other.getBuildArgs();
        if (this$buildArgs == null ? other$buildArgs != null : !this$buildArgs.equals(other$buildArgs)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        return !(this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : ((Object)$teamId).hashCode());
        Integer $gitCredential = this.getGitCredential();
        result = result * 59 + ($gitCredential == null ? 43 : ((Object)$gitCredential).hashCode());
        Integer $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        Integer $buildState = this.getBuildState();
        result = result * 59 + ($buildState == null ? 43 : ((Object)$buildState).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $branches = this.getBranches();
        result = result * 59 + ($branches == null ? 43 : $branches.hashCode());
        Date $lastBuild = this.getLastBuild();
        result = result * 59 + ($lastBuild == null ? 43 : ((Object)$lastBuild).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $prvkeyPath = this.getPrvkeyPath();
        result = result * 59 + ($prvkeyPath == null ? 43 : $prvkeyPath.hashCode());
        String $pom = this.getPom();
        result = result * 59 + ($pom == null ? 43 : $pom.hashCode());
        String $buildArgs = this.getBuildArgs();
        result = result * 59 + ($buildArgs == null ? 43 : $buildArgs.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        return result;
    }

    public String toString() {
        return "Project(id=" + this.getId() + ", teamId=" + this.getTeamId() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", branches=" + this.getBranches() + ", lastBuild=" + this.getLastBuild() + ", gitCredential=" + this.getGitCredential() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", prvkeyPath=" + this.getPrvkeyPath() + ", repository=" + this.getRepository() + ", pom=" + this.getPom() + ", buildArgs=" + this.getBuildArgs() + ", description=" + this.getDescription() + ", buildState=" + this.getBuildState() + ", type=" + this.getType() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", module=" + this.getModule() + ", dateFrom=" + this.getDateFrom() + ", dateTo=" + this.getDateTo() + ", appSource=" + this.getAppSource() + ")";
    }
}

