/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import java.io.Serializable;

public abstract class PropertyNamingStrategies
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new LowerCamelCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy UPPER_SNAKE_CASE = new UpperSnakeCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();

    public static class LowerDotCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            return this.translateLowerCaseWithSeparator(input2, '.');
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            return this.translateLowerCaseWithSeparator(input2, '-');
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            return input2.toLowerCase();
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            char uc;
            if (input2 == null || input2.isEmpty()) {
                return input2;
            }
            char c = input2.charAt(0);
            if (c == (uc = Character.toUpperCase(c))) {
                return input2;
            }
            StringBuilder sb = new StringBuilder(input2);
            sb.setCharAt(0, uc);
            return sb.toString();
        }
    }

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            return input2;
        }
    }

    public static class UpperSnakeCaseStrategy
    extends SnakeCaseStrategy {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            String output = super.translate(input2);
            if (output == null) {
                return null;
            }
            return super.translate(input2).toUpperCase();
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 2L;

        @Override
        public String translate(String input2) {
            if (input2 == null) {
                return input2;
            }
            int length = input2.length();
            StringBuilder result2 = new StringBuilder(length * 2);
            int resultLength = 0;
            boolean wasPrevTranslated = false;
            for (int i = 0; i < length; ++i) {
                char c = input2.charAt(i);
                if (i <= 0 && c == '_') continue;
                if (Character.isUpperCase(c)) {
                    if (!wasPrevTranslated && resultLength > 0 && result2.charAt(resultLength - 1) != '_') {
                        result2.append('_');
                        ++resultLength;
                    }
                    c = Character.toLowerCase(c);
                    wasPrevTranslated = true;
                } else {
                    wasPrevTranslated = false;
                }
                result2.append(c);
                ++resultLength;
            }
            return resultLength > 0 ? result2.toString() : input2;
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = 2L;

        @Override
        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.translate(defaultName);
        }

        public abstract String translate(String var1);

        protected String translateLowerCaseWithSeparator(String input2, char separator) {
            if (input2 == null) {
                return input2;
            }
            int length = input2.length();
            if (length == 0) {
                return input2;
            }
            StringBuilder result2 = new StringBuilder(length + (length >> 1));
            int upperCount = 0;
            for (int i = 0; i < length; ++i) {
                char ch = input2.charAt(i);
                char lc = Character.toLowerCase(ch);
                if (lc == ch) {
                    if (upperCount > 1) {
                        result2.insert(result2.length() - 1, separator);
                    }
                    upperCount = 0;
                } else {
                    if (upperCount == 0 && i > 0) {
                        result2.append(separator);
                    }
                    ++upperCount;
                }
                result2.append(lc);
            }
            return result2.toString();
        }
    }
}

