/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureCmdDoAs {
    private static final Logger LOG = LoggerFactory.getLogger(SecureCmdDoAs.class);
    private final Path tokenPath;
    private final File tokenFile;

    public SecureCmdDoAs(HiveConf conf) throws HiveException, IOException {
        String uname = UserGroupInformation.getLoginUser().getShortUserName();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Credentials cred = new Credentials();
        ShimLoader.getHadoopShims().addDelegationTokens(fs, cred, uname);
        for (String uri : conf.getStringCollection("mapreduce.job.hdfs-servers")) {
            try {
                ShimLoader.getHadoopShims().addDelegationTokens(FileSystem.get((URI)new URI(uri), (Configuration)conf), cred, uname);
            }
            catch (URISyntaxException e) {
                LOG.warn("Invalid URI in mapreduce.job.hdfs-servers:[" + uri + "], ignoring.", (Throwable)e);
            }
        }
        this.tokenFile = File.createTempFile("hive_hadoop_delegation_token", null);
        this.tokenPath = new Path(this.tokenFile.toURI());
        cred.writeTokenStorageFile(this.tokenPath, (Configuration)conf);
    }

    public void addEnv(Map<String, String> env) {
        env.put("HADOOP_TOKEN_FILE_LOCATION", this.tokenPath.toUri().getPath());
    }

    public void close() {
        this.tokenFile.delete();
    }
}

