/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.util.geo.GeometryCollection;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.LineString;
import org.apache.spark.sql.catalyst.util.geo.MultiLineString;
import org.apache.spark.sql.catalyst.util.geo.MultiPoint;
import org.apache.spark.sql.catalyst.util.geo.MultiPolygon;
import org.apache.spark.sql.catalyst.util.geo.Point;
import org.apache.spark.sql.catalyst.util.geo.Polygon;
import org.apache.spark.sql.catalyst.util.geo.Ring;

public class WkbWriter {
    private static int getWkbType(GeometryModel geometry) {
        int baseType = (int)geometry.getTypeId().getValue();
        boolean hasZ = geometry.hasZ();
        boolean hasM = geometry.hasM();
        if (hasZ && hasM) {
            return baseType + 3000;
        }
        if (hasZ) {
            return baseType + 1000;
        }
        if (hasM) {
            return baseType + 2000;
        }
        return baseType + 0;
    }

    public byte[] write(GeometryModel geometry) {
        return this.write(geometry, ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] write(GeometryModel geometry, ByteOrder byteOrder) {
        int size = this.calculateSize(geometry);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(byteOrder);
        this.writeGeometry(buffer, geometry, byteOrder);
        return buffer.array();
    }

    private int calculateSize(GeometryModel geometry) {
        int size;
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            int dimCount;
                            block7: {
                                block5: {
                                    dimCount = geometry.getDimensionCount();
                                    size = 5;
                                    if (!(geometry instanceof Point)) break block5;
                                    Point point = (Point)geometry;
                                    size += point.getCoordinates().length * 8;
                                    break block6;
                                }
                                if (!(geometry instanceof LineString)) break block7;
                                LineString lineString = (LineString)geometry;
                                size += 4;
                                size += lineString.getNumPoints() * dimCount * 8;
                                break block6;
                            }
                            if (!(geometry instanceof Polygon)) break block8;
                            Polygon polygon = (Polygon)geometry;
                            size += 4;
                            for (Ring ring : polygon.getRings()) {
                                int numPoints = ring.getNumPoints();
                                size += 4;
                                size += numPoints * dimCount * 8;
                            }
                            break block6;
                        }
                        if (!(geometry instanceof MultiPoint)) break block9;
                        MultiPoint mp = (MultiPoint)geometry;
                        size += 4;
                        for (Point p : mp.getPoints()) {
                            size += this.calculateSize(p);
                        }
                        break block6;
                    }
                    if (!(geometry instanceof MultiLineString)) break block10;
                    MultiLineString mls = (MultiLineString)geometry;
                    size += 4;
                    for (LineString ls : mls.getLineStrings()) {
                        size += this.calculateSize(ls);
                    }
                    break block6;
                }
                if (!(geometry instanceof MultiPolygon)) break block11;
                MultiPolygon mpoly = (MultiPolygon)geometry;
                size += 4;
                for (Polygon poly : mpoly.getPolygons()) {
                    size += this.calculateSize(poly);
                }
                break block6;
            }
            if (!(geometry instanceof GeometryCollection)) break block6;
            GeometryCollection gc = (GeometryCollection)geometry;
            size += 4;
            for (GeometryModel geom : gc.getGeometries()) {
                size += this.calculateSize(geom);
            }
        }
        return size;
    }

    private void writeGeometry(ByteBuffer buffer, GeometryModel geometry, ByteOrder byteOrder) {
        buffer.put(byteOrder == ByteOrder.LITTLE_ENDIAN ? (byte)1 : 0);
        int type = WkbWriter.getWkbType(geometry);
        buffer.putInt(type);
        if (geometry instanceof Point) {
            this.writePoint(buffer, (Point)geometry);
        } else if (geometry instanceof LineString) {
            this.writeLineString(buffer, (LineString)geometry);
        } else if (geometry instanceof Polygon) {
            this.writePolygon(buffer, (Polygon)geometry);
        } else if (geometry instanceof MultiPoint) {
            this.writeMultiPoint(buffer, (MultiPoint)geometry, byteOrder);
        } else if (geometry instanceof MultiLineString) {
            this.writeMultiLineString(buffer, (MultiLineString)geometry, byteOrder);
        } else if (geometry instanceof MultiPolygon) {
            this.writeMultiPolygon(buffer, (MultiPolygon)geometry, byteOrder);
        } else if (geometry instanceof GeometryCollection) {
            this.writeGeometryCollection(buffer, (GeometryCollection)geometry, byteOrder);
        }
    }

    private void writePoint(ByteBuffer buffer, Point point) {
        for (double coord : point.getCoordinates()) {
            buffer.putDouble(coord);
        }
    }

    private void writeLineString(ByteBuffer buffer, LineString lineString) {
        buffer.putInt(lineString.getNumPoints());
        for (Point point : lineString.getPoints()) {
            this.writePoint(buffer, point);
        }
    }

    private void writeRing(ByteBuffer buffer, Ring ring) {
        int numPoints = ring.getNumPoints();
        buffer.putInt(numPoints);
        for (Point point : ring.getPoints()) {
            this.writePoint(buffer, point);
        }
    }

    private void writePolygon(ByteBuffer buffer, Polygon polygon) {
        buffer.putInt(polygon.getRings().size());
        for (Ring ring : polygon.getRings()) {
            this.writeRing(buffer, ring);
        }
    }

    private void writeMultiPoint(ByteBuffer buffer, MultiPoint multiPoint, ByteOrder byteOrder) {
        buffer.putInt(multiPoint.getNumGeometries());
        for (Point point : multiPoint.getPoints()) {
            this.writeGeometry(buffer, point, byteOrder);
        }
    }

    private void writeMultiLineString(ByteBuffer buffer, MultiLineString multiLineString, ByteOrder byteOrder) {
        buffer.putInt(multiLineString.getNumGeometries());
        for (LineString lineString : multiLineString.getLineStrings()) {
            this.writeGeometry(buffer, lineString, byteOrder);
        }
    }

    private void writeMultiPolygon(ByteBuffer buffer, MultiPolygon multiPolygon, ByteOrder byteOrder) {
        buffer.putInt(multiPolygon.getNumGeometries());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            this.writeGeometry(buffer, polygon, byteOrder);
        }
    }

    private void writeGeometryCollection(ByteBuffer buffer, GeometryCollection collection, ByteOrder byteOrder) {
        buffer.putInt(collection.getNumGeometries());
        for (GeometryModel geometry : collection.getGeometries()) {
            this.writeGeometry(buffer, geometry, byteOrder);
        }
    }
}

