/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.Point;

class Ring {
    private final List<Point> points;

    Ring(List<Point> points) {
        this.points = points;
    }

    List<Point> getPoints() {
        return this.points;
    }

    int getNumPoints() {
        return this.points.size();
    }

    boolean isEmpty() {
        return this.points.isEmpty();
    }

    boolean isClosed() {
        if (this.points.size() < 4) {
            return false;
        }
        Point first = this.points.get(0);
        Point last = this.points.get(this.points.size() - 1);
        return Ring.coordinatesEqual(first.getCoordinates(), last.getCoordinates());
    }

    private static boolean coordinatesEqual(double[] coords1, double[] coords2) {
        if (coords1.length != coords2.length) {
            return false;
        }
        for (int i = 0; i < coords1.length; ++i) {
            if (coords1[i] == coords2[i]) continue;
            return false;
        }
        return true;
    }
}

