/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ApproxTopKEstimate$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(state, k) - Returns top k items with their frequency.\n      `k` An optional INTEGER literal greater than 0. If k is not specified, it defaults to 5.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(approx_top_k_accumulate(expr)) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT _FUNC_(approx_top_k_accumulate(expr), 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n  ", group="sketch_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u0012%\u0001FB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015I\u0006\u0001\"\u0001_\u0011\u0015I\u0006\u0001\"\u0001g\u0011!A\u0007\u0001#b\u0001\n\u0013I\u0007\"\u00029\u0001\t\u0003\u0012\u0006\"B9\u0001\t\u0003\u0012\u0006\"\u0002:\u0001\t\u0003\u001a\b\"\u0002>\u0001\t\u0003Z\bBBA\u0003\u0001\u0011\u0005\u0013\u000eC\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005u\u0001\u0001\"\u0015\u0002 !9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0014\u0001#\u0003%\t!!\u0015\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005E\u0003\"CA5\u0001\u0005\u0005I\u0011IA6\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0012\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033C\u0011\"!(\u0001\u0003\u0003%\t%a(\t\u0013\u0005\r\u0006!!A\u0005B\u0005\u0015v!CAeI\u0005\u0005\t\u0012AAf\r!\u0019C%!A\t\u0002\u00055\u0007BB-\u001e\t\u0003\t)\u000fC\u0005\u0002hv\t\t\u0011\"\u0012\u0002j\"I\u00111^\u000f\u0002\u0002\u0013\u0005\u0015Q\u001e\u0005\n\u0003gl\u0012\u0011!CA\u0003kD\u0011Ba\u0002\u001e\u0003\u0003%IA!\u0003\u0003%\u0005\u0003\bO]8y)>\u00048*R:uS6\fG/\u001a\u0006\u0003K\u0019\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0005K\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M1\u0001A\r\u001c=\u007f\u0015\u0003\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001c;\u001b\u0005A$BA\u001d%\u0003\u001d\u0019w\u000eZ3hK:L!a\u000f\u001d\u0003\u001f\r{G-Z4f]\u001a\u000bG\u000e\u001c2bG.\u0004\"aM\u001f\n\u0005y\"#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u000fA\u0013x\u000eZ;diB\u0011aI\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015BA'B\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00055\u000b\u0015!B:uCR,W#A*\u0011\u0005M\"\u0016BA+%\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007gR\fG/\u001a\u0011\u0002\u0003-\f!a\u001b\u0011\u0002\rqJg.\u001b;?)\rYF,\u0018\t\u0003g\u0001AQ!U\u0003A\u0002MCQaV\u0003A\u0002M#2aW0b\u0011\u0015\u0001g\u00011\u0001T\u0003\u0015\u0019\u0007.\u001b7e\u0011\u0015\u0011g\u00011\u0001d\u0003\u0011!x\u000e]&\u0011\u0005\u0001#\u0017BA3B\u0005\rIe\u000e\u001e\u000b\u00037\u001eDQ\u0001Y\u0004A\u0002M\u000bA\"\u001b;f[\u0012\u000bG/\u0019+za\u0016,\u0012A\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\"\nQ\u0001^=qKNL!a\u001c7\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003Q\u00042AR;x\u0013\t1\bKA\u0002TKF\u0004\"a\u001b=\n\u0005ed'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000M\u0005A\u0011M\\1msNL7/C\u0002\u0002\u0004y\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\tI\u0006$\u0018\rV=qK\u0006!QM^1m)\u0011\tY!!\u0005\u0011\u0007\u0001\u000bi!C\u0002\u0002\u0010\u0005\u00131!\u00118z\u0011%\t\u0019B\u0004I\u0001\u0002\u0004\t)\"A\u0003j]B,H\u000f\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0014\n\u0007\u0005maEA\u0006J]R,'O\\1m%><\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\u0019\u0016\u0011EA\u0013\u0011\u0019\t\u0019c\u0004a\u0001'\u0006Aa.Z<Ti\u0006$X\r\u0003\u0004\u0002(=\u0001\raU\u0001\u0005]\u0016<8*\u0001\u0005ok2d\u0017M\u00197f+\t\ti\u0003E\u0002A\u0003_I1!!\rB\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\t\t9\u0004\u0005\u0003\u0002:\u0005\u0005c\u0002BA\u001e\u0003{\u0001\"\u0001S!\n\u0007\u0005}\u0012)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\n)E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u007f\t\u0015\u0001B2paf$RaWA&\u0003\u001bBq!\u0015\n\u0011\u0002\u0003\u00071\u000bC\u0004X%A\u0005\t\u0019A*\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u000b\u0016\u0004'\u0006U3FAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0014)\u0001\u0006b]:|G/\u0019;j_:LA!!\u001a\u0002\\\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!A.\u00198h\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003c\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012aY\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY!a!\t\u0011\u0005\u0015u#!AA\u0002\r\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAF!\u0019\ti)a%\u0002\f5\u0011\u0011q\u0012\u0006\u0004\u0003#\u000b\u0015AC2pY2,7\r^5p]&!\u0011QSAH\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055\u00121\u0014\u0005\n\u0003\u000bK\u0012\u0011!a\u0001\u0003\u0017\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QNAQ\u0011!\t)IGA\u0001\u0002\u0004\u0019\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002.\u0005\u001d\u0006\"CAC7\u0005\u0005\t\u0019AA\u0006QM\u0001\u00111VAY\u0003g\u000b9,!/\u0002>\u0006}\u00161YAc!\r\u0019\u0014QV\u0005\u0004\u0003_##!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003k\u000b\u0011q\t\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f^1uK2\u00023.\u000b\u0011.AI+G/\u001e:og\u0002\"x\u000e\u001d\u0011lA%$X-\\:!o&$\b\u000e\t;iK&\u0014\bE\u001a:fcV,gnY=/\u0015\u0001\u0002\u0003\u0005\t\u0011!A.\u0004\u0007%\u00118!_B$\u0018n\u001c8bY\u0002Je\nV#H\u000bJ\u0003C.\u001b;fe\u0006d\u0007e\u001a:fCR,'\u000f\t;iC:\u0004\u0003G\f\u0011JM\u0002Z\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3-A%$\b\u0005Z3gCVdGo\u001d\u0011u_\u0002*dF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA^\u0003\r=#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1qaJ|\u0007p\u0018;pa~[w,Y2dk6,H.\u0019;fQ\u0015D\bO]\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u0019*Y\u0001B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003fM\u0015-A!\"\u0014\u0006\f\u0011)i%\u0002\u0013i\u0015\u0011uC\nDS\r\u001f9sSmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u0012ji\u0016l'E\u000f\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001b-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'EO\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001a-E\r|WO\u001c;#uEjHf\u001f\u0012ji\u0016l'EO\u001a-E\r|WO\u001c;#uEjXL\u0003\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CB\u0004(o\u001c=`i>\u0004xl[0bG\u000e,X.\u001e7bi\u0016DS\r\u001f9sS1\u0002#'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006eJ1(Y\u0001:#m\n\u0017!O\r<C\u0006I\u0014dO1\u0002seY\u0014-A\u001d\u001aw\u0005\f\u0011(I\u001eb\u0003e\n3(AQ\f'\rK3yaJL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.|E%$X-\u001c\u0012;E\r\u0014CFI2pk:$(E\u000f\u001b~Ym\u0014\u0013\u000e^3nEi\u0012CM\t\u0017#G>,h\u000e\u001e\u0012;eul&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0005\u0017\u0001D:lKR\u001c\u0007n\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAd\u0003\u0015!d&\r\u00181\u0003I\t\u0005\u000f\u001d:pqR{\u0007oS#ti&l\u0017\r^3\u0011\u0005Mj2#B\u000f\u0002P\u0006m\u0007cBAi\u0003/\u001c6kW\u0007\u0003\u0003'T1!!6B\u0003\u001d\u0011XO\u001c;j[\u0016LA!!7\u0002T\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005u\u00171]\u0007\u0003\u0003?TA!!9\u0002v\u0005\u0011\u0011n\\\u0005\u0004\u001f\u0006}GCAAf\u0003!!xn\u0015;sS:<GCAA7\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Y\u0016q^Ay\u0011\u0015\t\u0006\u00051\u0001T\u0011\u00159\u0006\u00051\u0001T\u0003\u001d)h.\u00199qYf$B!a>\u0003\u0004A)\u0001)!?\u0002~&\u0019\u00111`!\u0003\r=\u0003H/[8o!\u0015\u0001\u0015q`*T\u0013\r\u0011\t!\u0011\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t\u0015\u0011%!AA\u0002m\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u0001\u0005\u0003\u0002p\t5\u0011\u0002\u0002B\b\u0003c\u0012aa\u00142kK\u000e$\b")
public class ApproxTopKEstimate
extends BinaryExpression
implements CodegenFallback,
ImplicitCastInputTypes,
Serializable {
    private DataType itemDataType;
    private final Expression state;
    private final Expression k;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ApproxTopKEstimate x$0) {
        return ApproxTopKEstimate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ApproxTopKEstimate> tupled() {
        return ApproxTopKEstimate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ApproxTopKEstimate>> curried() {
        return ApproxTopKEstimate$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression state() {
        return this.state;
    }

    public Expression k() {
        return this.k;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopKEstimate approxTopKEstimate = this;
        synchronized (approxTopKEstimate) {
            if (!this.bitmap$0) {
                this.itemDataType = ((StructType)this.state().dataType()).apply(2).dataType();
                this.bitmap$0 = true;
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if (!this.bitmap$0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    @Override
    public Expression left() {
        return this.state();
    }

    @Override
    public Expression right() {
        return this.k();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StructType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        TypeCheckResult stateCheck = ApproxTopK$.MODULE$.checkStateFieldAndType(this.state());
        if (stateCheck.isFailure()) {
            return stateCheck;
        }
        if (!this.k().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("K must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getResultDataType(this.itemDataType());
    }

    @Override
    public Object eval(InternalRow input) {
        ApproxTopK$.MODULE$.checkExpressionNotNull(this.k(), "k");
        Object stateEval = this.left().eval(input);
        Object kEval = this.right().eval(input);
        byte[] dataSketchBytes = ((InternalRow)stateEval).getBinary(0);
        int maxItemsTrackedVal = ((InternalRow)stateEval).getInt(1);
        int kVal = BoxesRunTime.unboxToInt((Object)kEval);
        ApproxTopK$.MODULE$.checkK(kVal);
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal, kVal);
        ApproxTopKAggregateBuffer<Object> approxTopKAggregateBuffer = ApproxTopKAggregateBuffer$.MODULE$.deserialize(dataSketchBytes, ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
        return approxTopKAggregateBuffer.eval(kVal, this.itemDataType());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newState, Expression newK) {
        return this.copy(newState, newK);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k_estimate");
    }

    public ApproxTopKEstimate copy(Expression state, Expression k) {
        return new ApproxTopKEstimate(state, k);
    }

    public Expression copy$default$1() {
        return this.state();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopKEstimate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.state();
            }
            case 1: {
                return this.k();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopKEstimate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "state";
            }
            case 1: {
                return "k";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopKEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopKEstimate approxTopKEstimate = (ApproxTopKEstimate)x$1;
        Expression expression = this.state();
        Expression expression2 = approxTopKEstimate.state();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = approxTopKEstimate.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!approxTopKEstimate.canEqual(this)) return false;
        return true;
    }

    public ApproxTopKEstimate(Expression state, Expression k) {
        this.state = state;
        this.k = k;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ApproxTopKEstimate(Expression child, int topK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)));
    }

    public ApproxTopKEstimate(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_K())));
    }
}

