/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.CSVOptions$;
import org.apache.spark.sql.catalyst.expressions.BinaryFormatter;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.ToStringBase$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimeFormatter;
import org.apache.spark.sql.catalyst.util.TimeFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df\u0001\u0002\u0011\"\u00019B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!AQ\t\u0001B\u0001B\u0003%a\tC\u0003K\u0001\u0011\u00051\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ru\u0003\u0001\u0015!\u0003S\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001W\u0001\u00023\u0001\t\u0015Dq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005%\u0001A1A\u0005\n\u0005-\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0004\t\u0013\u0005m\u0001A1A\u0005\n\u0005-\u0001\u0002CA\u000f\u0001\u0001\u0006I!!\u0004\t\u0013\u0005}\u0001A1A\u0005\n\u0005\u0005\u0002\u0002CA\u0015\u0001\u0001\u0006I!a\t\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\f\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002\u0002CA!\u0001\u0001\u0006I!a\u000f\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA'\u0001\u0001\u0006I!a\u0012\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\t9\n\u0001C\u0001\u00033Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002$\u0002!\t!!&\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002\u0016\n\u0011RK\\5w_\u000eLG/_$f]\u0016\u0014\u0018\r^8s\u0015\t\u00113%A\u0002dgZT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019\u00198\r[3nCB\u0011qGO\u0007\u0002q)\u0011\u0011(J\u0001\u0006if\u0004Xm]\u0005\u0003wa\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u00199(/\u001b;feB\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0003S>T\u0011AQ\u0001\u0005U\u00064\u0018-\u0003\u0002E\u007f\t1qK]5uKJ\fqa\u001c9uS>t7\u000f\u0005\u0002H\u00116\t\u0011%\u0003\u0002JC\tQ1i\u0015,PaRLwN\\:\u0002\rqJg.\u001b;?)\u0011aUJT(\u0011\u0005\u001d\u0003\u0001\"B\u001b\u0005\u0001\u00041\u0004\"\u0002\u001f\u0005\u0001\u0004i\u0004\"B#\u0005\u0001\u00041\u0015AD<sSR,'oU3ui&twm]\u000b\u0002%B\u00111kW\u0007\u0002)*\u0011!%\u0016\u0006\u0003-^\u000bq\u0001]1sg\u0016\u00148O\u0003\u0002Y3\u0006IQO\\5w_\u000eLG/\u001f\u0006\u00025\u0006\u00191m\\7\n\u0005q#&!E\"tm^\u0013\u0018\u000e^3s'\u0016$H/\u001b8hg\u0006yqO]5uKJ\u001cV\r\u001e;j]\u001e\u001c\b%A\u0002hK:,\u0012\u0001\u0019\t\u0003'\u0006L!A\u0019+\u0003\u0013\r\u001bho\u0016:ji\u0016\u0014\u0018\u0001B4f]\u0002\u0012aBV1mk\u0016\u001cuN\u001c<feR,'\u000fE\u00031M\"t\u0017/\u0003\u0002hc\tIa)\u001e8di&|gN\r\t\u0003S2l\u0011A\u001b\u0006\u0003W\u000e\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011QN\u001b\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000f\u0005\u00021_&\u0011\u0001/\r\u0002\u0004\u0013:$\bC\u0001:z\u001d\t\u0019x\u000f\u0005\u0002uc5\tQO\u0003\u0002w[\u00051AH]8pizJ!\u0001_\u0019\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003qF\nqB^1mk\u0016\u001cuN\u001c<feR,'o]\u000b\u0002}B!\u0001g`A\u0002\u0013\r\t\t!\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0003\u000bIQ\"\u0001\u0001\u0002!Y\fG.^3D_:4XM\u001d;feN\u0004\u0013A\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ,\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005$\u0003\u0011)H/\u001b7\n\t\u0005]\u0011\u0011\u0003\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'/A\nuS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\b%A\u000buS6,7\u000f^1na:#&LR8s[\u0006$H/\u001a:\u0002-QLW.Z:uC6\u0004h\n\u0016.G_Jl\u0017\r\u001e;fe\u0002\nQ\u0002Z1uK\u001a{'/\\1ui\u0016\u0014XCAA\u0012!\u0011\ty!!\n\n\t\u0005\u001d\u0012\u0011\u0003\u0002\u000e\t\u0006$XMR8s[\u0006$H/\u001a:\u0002\u001d\u0011\fG/\u001a$pe6\fG\u000f^3sA\u0005iA/[7f\r>\u0014X.\u0019;uKJ,\"!a\f\u0011\t\u0005=\u0011\u0011G\u0005\u0005\u0003g\t\tBA\u0007US6,gi\u001c:nCR$XM]\u0001\u000fi&lWMR8s[\u0006$H/\u001a:!\u0003]qW\u000f\u001c7BgF+x\u000e^3e\u000b6\u0004H/_*ue&tw-\u0006\u0002\u0002<A\u0019\u0001'!\u0010\n\u0007\u0005}\u0012GA\u0004C_>dW-\u00198\u000219,H\u000e\\!t#V|G/\u001a3F[B$\u0018p\u0015;sS:<\u0007%A\bcS:\f'/\u001f$pe6\fG\u000f^3s+\t\t9\u0005E\u0002j\u0003\u0013J1!a\u0013k\u0005=\u0011\u0015N\\1ss\u001a{'/\\1ui\u0016\u0014\u0018\u0001\u00052j]\u0006\u0014\u0018PR8s[\u0006$H/\u001a:!\u00035i\u0017m[3D_:4XM\u001d;feR!\u00111AA*\u0011\u001d\t)\u0006\u0007a\u0001\u0003/\n\u0001\u0002Z1uCRK\b/\u001a\t\u0004o\u0005e\u0013bAA.q\tAA)\u0019;b)f\u0004X-\u0001\u0006baB,g\u000e\u001a(vY2$B!!\u0019\u0002hA\u0019\u0001'a\u0019\n\u0007\u0005\u0015\u0014G\u0001\u0003V]&$\bbBA53\u0001\u0007\u00111N\u0001\bEVLG\u000eZ3s!\u0011\ti'a\u001e\u000f\t\u0005=\u00141\u000f\b\u0004i\u0006E\u0014\"\u0001\u001a\n\u0007\u0005U\u0014'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u000b\u0007\u0005U\u0014'\u0001\u0006d_:4XM\u001d;S_^$B!!!\u0002\bB)\u0011QNABc&!\u0011QQA>\u0005\r\u0019V-\u001d\u0005\b\u0003\u0013S\u0002\u0019AAF\u0003\r\u0011xn\u001e\t\u0005\u0003\u001b\u000by)D\u0001$\u0013\r\t\tj\t\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007xe&$X\rS3bI\u0016\u00148\u000f\u0006\u0002\u0002b\u0005)qO]5uKR!\u0011\u0011MAN\u0011\u001d\tI\t\ba\u0001\u0003\u0017\u000bQb\u001e:ji\u0016$vn\u0015;sS:<GcA9\u0002\"\"9\u0011\u0011R\u000fA\u0002\u0005-\u0015!B2m_N,\u0017!\u00024mkND\u0007")
public class UnivocityGenerator {
    private final CSVOptions options;
    private final CsvWriterSettings writerSettings;
    private final CsvWriter gen;
    private final Function2<SpecializedGetters, Object, String>[] valueConverters;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private final TimeFormatter timeFormatter;
    private final boolean nullAsQuotedEmptyString;
    private final BinaryFormatter binaryFormatter;

    private CsvWriterSettings writerSettings() {
        return this.writerSettings;
    }

    private CsvWriter gen() {
        return this.gen;
    }

    private Function2<SpecializedGetters, Object, String>[] valueConverters() {
        return this.valueConverters;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private TimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    private boolean nullAsQuotedEmptyString() {
        return this.nullAsQuotedEmptyString;
    }

    private BinaryFormatter binaryFormatter() {
        return this.binaryFormatter;
    }

    private Function2<SpecializedGetters, Object, String> makeConverter(DataType dataType2) {
        DataType dataType3;
        while (true) {
            if (BinaryType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$1(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$2(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$3(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$4(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType3 instanceof TimeType) {
                return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$5(this, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
            if (dataType3 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toYearMonthIntervalString(getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (dataType3 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable)(getter, ordinal) -> IntervalUtils$.MODULE$.toDayTimeIntervalString(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start, end);
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            DataType et = arrayType.elementType();
            Function2<SpecializedGetters, Object, String> elementConverter = this.makeConverter(et);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$8(this, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            Function2<SpecializedGetters, Object, String> keyConverter = this.makeConverter(kt);
            Function2<SpecializedGetters, Object, String> valueConverter = this.makeConverter(vt);
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$9(this, keyConverter, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            StructField[] fields = structType.fields();
            Function2[] converters = (Function2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$2 -> x$2.dataType(), ClassTag$.MODULE$.apply(DataType.class))), (Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType), ClassTag$.MODULE$.apply(Function2.class));
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$12(this, fields, converters, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        if (dataType3 != null) {
            DataType dataType4 = dataType3;
            return (Function2 & Serializable)(getter, ordinal) -> UnivocityGenerator.$anonfun$makeConverter$13(dataType4, getter, BoxesRunTime.unboxToInt((Object)ordinal));
        }
        throw new MatchError((Object)dataType3);
    }

    private void appendNull(StringBuilder builder) {
        Option option = this.options.parameters().get(CSVOptions$.MODULE$.NULL_VALUE());
        if (option instanceof Some) {
            builder.append(" " + this.options.nullValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private Seq<String> convertRow(InternalRow row) {
        String[] values = new String[row.numFields()];
        for (int i = 0; i < row.numFields(); ++i) {
            if (!row.isNullAt(i)) {
                values[i] = (String)this.valueConverters()[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.nullAsQuotedEmptyString()) continue;
            values[i] = this.options.nullValue();
        }
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq();
    }

    public void writeHeaders() {
        this.gen().writeHeaders();
    }

    public void write(InternalRow row) {
        this.gen().writeRow((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public String writeToString(InternalRow row) {
        return this.gen().writeRowToString((Object[])this.convertRow(row).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$1(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return ((UTF8String)$this.binaryFormatter().apply(getter.getBinary(ordinal))).toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$2(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.dateFormatter().format(getter.getInt(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$3(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampFormatter().format(getter.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$4(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(getter.getLong(ordinal)));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$5(UnivocityGenerator $this, SpecializedGetters getter, int ordinal) {
        return $this.timeFormatter().format(getter.getLong(ordinal));
    }

    public static final /* synthetic */ String $anonfun$makeConverter$8(UnivocityGenerator $this, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData array = getter.getArray(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (array.numElements() > 0) {
            if (array.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (array.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + elementConverter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$9(UnivocityGenerator $this, Function2 keyConverter$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData map = getter.getMap(ordinal);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (map.numElements() > 0) {
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            builder.append(" ->");
            if (valueArray.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < map.numElements(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(", ");
                builder.append((String)keyConverter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i)));
                builder.append(" ->");
                if (valueArray.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$12(UnivocityGenerator $this, StructField[] fields$1, Function2[] converters$1, SpecializedGetters getter, int ordinal) {
        InternalRow row = getter.getStruct(ordinal, fields$1.length);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (row.numFields() > 0) {
            if (row.isNullAt(0)) {
                $this.appendNull(builder);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = builder.append((String)converters$1[0].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)0)));
            }
            for (int i = 1; i < row.numFields(); ++i) {
                BoxedUnit boxedUnit;
                builder.append(",");
                if (row.isNullAt(i)) {
                    $this.appendNull(builder);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = builder.append(" " + converters$1[i].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static final /* synthetic */ String $anonfun$makeConverter$13(DataType x15$1, SpecializedGetters getter, int ordinal) {
        return getter.get(ordinal, x15$1).toString();
    }

    public UnivocityGenerator(StructType schema, Writer writer, CSVOptions options) {
        this.options = options;
        this.writerSettings = options.asWriterSettings();
        this.writerSettings().setHeaders(schema.fieldNames());
        this.gen = new CsvWriter(writer, this.writerSettings());
        this.valueConverters = (Function2[])((IterableOnceOps)((IterableOps)schema.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeConverter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        String string = options.timeFormatInWrite();
        String string2 = TimeFormatter$.MODULE$.defaultPattern();
        String string3 = string;
        this.timeFormatter = !(string2 != null ? !string2.equals(string3) : string3 != null) ? TimeFormatter$.MODULE$.getFractionFormatter() : TimeFormatter$.MODULE$.apply(string, false);
        this.nullAsQuotedEmptyString = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_NULL_VALUE_WRITTEN_AS_QUOTED_EMPTY_STRING_CSV()));
        this.binaryFormatter = ToStringBase$.MODULE$.getBinaryFormatter();
    }
}

