/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicy;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicyRange;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicyRangeBuilder;
import io.fabric8.kubernetes.api.model.resource.v1.CapacityRequestPolicyRangeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CapacityRequestPolicyFluent<A extends CapacityRequestPolicyFluent<A>>
extends BaseFluent<A> {
    private Quantity _default;
    private Map<String, Object> additionalProperties;
    private CapacityRequestPolicyRangeBuilder validRange;
    private List<Quantity> validValues = new ArrayList<Quantity>();

    public CapacityRequestPolicyFluent() {
    }

    public CapacityRequestPolicyFluent(CapacityRequestPolicy instance) {
        this.copyInstance(instance);
    }

    public A addAllToValidValues(Collection<Quantity> items) {
        if (this.validValues == null) {
            this.validValues = new ArrayList<Quantity>();
        }
        for (Quantity item : items) {
            this.validValues.add(item);
        }
        return (A)((Object)this);
    }

    public A addNewValidValue(String amount) {
        return this.addToValidValues(new Quantity(amount));
    }

    public A addNewValidValue(String amount, String format) {
        return this.addToValidValues(new Quantity(amount, format));
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToValidValues(Quantity ... items) {
        if (this.validValues == null) {
            this.validValues = new ArrayList<Quantity>();
        }
        for (Quantity item : items) {
            this.validValues.add(item);
        }
        return (A)((Object)this);
    }

    public A addToValidValues(int index, Quantity item) {
        if (this.validValues == null) {
            this.validValues = new ArrayList<Quantity>();
        }
        this.validValues.add(index, item);
        return (A)((Object)this);
    }

    public CapacityRequestPolicyRange buildValidRange() {
        return this.validRange != null ? this.validRange.build() : null;
    }

    protected void copyInstance(CapacityRequestPolicy instance) {
        CapacityRequestPolicy capacityRequestPolicy = instance = instance != null ? instance : new CapacityRequestPolicy();
        if (instance != null) {
            this.withDefault(instance.getDefault());
            this.withValidRange(instance.getValidRange());
            this.withValidValues(instance.getValidValues());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ValidRangeNested<A> editOrNewValidRange() {
        return this.withNewValidRangeLike(Optional.ofNullable(this.buildValidRange()).orElse(new CapacityRequestPolicyRangeBuilder().build()));
    }

    public ValidRangeNested<A> editOrNewValidRangeLike(CapacityRequestPolicyRange item) {
        return this.withNewValidRangeLike(Optional.ofNullable(this.buildValidRange()).orElse(item));
    }

    public ValidRangeNested<A> editValidRange() {
        return this.withNewValidRangeLike(Optional.ofNullable(this.buildValidRange()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapacityRequestPolicyFluent that = (CapacityRequestPolicyFluent)((Object)o);
        if (!Objects.equals(this._default, that._default)) {
            return false;
        }
        if (!Objects.equals((Object)this.validRange, (Object)that.validRange)) {
            return false;
        }
        if (!Objects.equals(this.validValues, that.validValues)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Quantity getDefault() {
        return this._default;
    }

    public Quantity getFirstValidValue() {
        return this.validValues.get(0);
    }

    public Quantity getLastValidValue() {
        return this.validValues.get(this.validValues.size() - 1);
    }

    public Quantity getMatchingValidValue(Predicate<Quantity> predicate) {
        for (Quantity item : this.validValues) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Quantity getValidValue(int index) {
        return this.validValues.get(index);
    }

    public List<Quantity> getValidValues() {
        return this.validValues;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDefault() {
        return this._default != null;
    }

    public boolean hasMatchingValidValue(Predicate<Quantity> predicate) {
        for (Quantity item : this.validValues) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasValidRange() {
        return this.validRange != null;
    }

    public boolean hasValidValues() {
        return this.validValues != null && !this.validValues.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._default, this.validRange, this.validValues, this.additionalProperties});
    }

    public A removeAllFromValidValues(Collection<Quantity> items) {
        if (this.validValues == null) {
            return (A)((Object)this);
        }
        for (Quantity item : items) {
            this.validValues.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromValidValues(Quantity ... items) {
        if (this.validValues == null) {
            return (A)((Object)this);
        }
        for (Quantity item : items) {
            this.validValues.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToValidValues(int index, Quantity item) {
        if (this.validValues == null) {
            this.validValues = new ArrayList<Quantity>();
        }
        this.validValues.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this._default != null) {
            sb.append("_default:");
            sb.append(this._default);
            sb.append(",");
        }
        if (this.validRange != null) {
            sb.append("validRange:");
            sb.append((Object)this.validRange);
            sb.append(",");
        }
        if (this.validValues != null && !this.validValues.isEmpty()) {
            sb.append("validValues:");
            sb.append(this.validValues);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDefault(Quantity _default) {
        this._default = _default;
        return (A)((Object)this);
    }

    public A withNewDefault(String amount) {
        return this.withDefault(new Quantity(amount));
    }

    public A withNewDefault(String amount, String format) {
        return this.withDefault(new Quantity(amount, format));
    }

    public ValidRangeNested<A> withNewValidRange() {
        return new ValidRangeNested(null);
    }

    public ValidRangeNested<A> withNewValidRangeLike(CapacityRequestPolicyRange item) {
        return new ValidRangeNested(item);
    }

    public A withValidRange(CapacityRequestPolicyRange validRange) {
        this._visitables.remove((Object)"validRange");
        if (validRange != null) {
            this.validRange = new CapacityRequestPolicyRangeBuilder(validRange);
            this._visitables.get((Object)"validRange").add(this.validRange);
        } else {
            this.validRange = null;
            this._visitables.get((Object)"validRange").remove((Object)this.validRange);
        }
        return (A)((Object)this);
    }

    public A withValidValues(List<Quantity> validValues) {
        if (validValues != null) {
            this.validValues = new ArrayList<Quantity>();
            for (Quantity item : validValues) {
                this.addToValidValues(item);
            }
        } else {
            this.validValues = null;
        }
        return (A)((Object)this);
    }

    public A withValidValues(Quantity ... validValues) {
        if (this.validValues != null) {
            this.validValues.clear();
            this._visitables.remove((Object)"validValues");
        }
        if (validValues != null) {
            for (Quantity item : validValues) {
                this.addToValidValues(item);
            }
        }
        return (A)((Object)this);
    }

    public class ValidRangeNested<N>
    extends CapacityRequestPolicyRangeFluent<ValidRangeNested<N>>
    implements Nested<N> {
        CapacityRequestPolicyRangeBuilder builder;

        ValidRangeNested(CapacityRequestPolicyRange item) {
            this.builder = new CapacityRequestPolicyRangeBuilder(this, item);
        }

        public N and() {
            return (N)CapacityRequestPolicyFluent.this.withValidRange(this.builder.build());
        }

        public N endValidRange() {
            return this.and();
        }
    }
}

