/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.ee10.servlet.AsyncContentProducer;
import org.sparkproject.jetty.ee10.servlet.BlockingContentProducer;
import org.sparkproject.jetty.ee10.servlet.ContentProducer;
import org.sparkproject.jetty.ee10.servlet.ServletChannel;
import org.sparkproject.jetty.ee10.servlet.ServletChannelState;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.thread.AutoLock;
import org.sparkproject.jetty.util.thread.Invocable;

public class HttpInput
extends ServletInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(HttpInput.class);
    final AutoLock _lock = new AutoLock();
    private final ServletChannel _servletChannel;
    private final ServletChannelState _channelState;
    private final byte[] _oneByteBuffer = new byte[1];
    final BlockingContentProducer _blockingContentProducer;
    final AsyncContentProducer _asyncContentProducer;
    private final LongAdder _contentConsumed = new LongAdder();
    private volatile ContentProducer _contentProducer;
    private volatile boolean _consumedEof;
    private volatile ReadListener _readListener;

    public HttpInput(ServletChannel channel) {
        this._servletChannel = channel;
        this._channelState = this._servletChannel.getServletRequestState();
        this._asyncContentProducer = new AsyncContentProducer(this._servletChannel, this._lock);
        this._blockingContentProducer = new BlockingContentProducer(this._asyncContentProducer);
        this._contentProducer = this._blockingContentProducer;
    }

    public void recycle() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycle {}", (Object)this);
            }
            this._blockingContentProducer.recycle();
            this._contentProducer = this._blockingContentProducer;
            this._readListener = null;
        }
    }

    public void reopen() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("reopen {}", (Object)this);
            }
            this._blockingContentProducer.reopen();
            this._contentProducer = this._blockingContentProducer;
            this._consumedEof = false;
            this._readListener = null;
            this._contentConsumed.reset();
        }
    }

    private int get(Content.Chunk chunk, byte[] bytes, int offset, int length) {
        length = Math.min(chunk.remaining(), length);
        chunk.getByteBuffer().get(bytes, offset, length);
        this._contentConsumed.add(length);
        return length;
    }

    private int get(Content.Chunk chunk, ByteBuffer des) {
        int capacity = des.remaining();
        ByteBuffer src = chunk.getByteBuffer();
        if (src.remaining() > capacity) {
            int limit = src.limit();
            src.limit(src.position() + capacity);
            des.put(src);
            src.limit(limit);
        } else {
            des.put(src);
        }
        int consumed = capacity - des.remaining();
        this._contentConsumed.add(consumed);
        return consumed;
    }

    public long getContentConsumed() {
        return this._contentConsumed.sum();
    }

    public long getContentReceived() {
        try (AutoLock ignored = this._lock.lock();){
            long l = this._contentProducer.getBytesArrived();
            return l;
        }
    }

    public boolean consumeAvailable() {
        try (AutoLock ignored = this._lock.lock();){
            boolean atEof;
            if (LOG.isDebugEnabled()) {
                LOG.debug("consumeAll {}", (Object)this);
            }
            if (atEof = this._contentProducer.consumeAvailable()) {
                this._consumedEof = true;
            }
            if (this.isFinished()) {
                boolean bl = !this.isError();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isError() {
        try (AutoLock ignored = this._lock.lock();){
            boolean error = this._contentProducer.isError();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isError={} {}", (Object)error, (Object)this);
            }
            boolean bl = error;
            return bl;
        }
    }

    public boolean isAsync() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isAsync read listener {} {}", (Object)this._readListener, (Object)this);
        }
        return this._readListener != null;
    }

    public Invocable.InvocationType getInvocationType() {
        return this._readListener == null ? Invocable.InvocationType.NON_BLOCKING : Invocable.getInvocationType(this._readListener);
    }

    public boolean isFinished() {
        boolean finished = this._consumedEof;
        if (LOG.isDebugEnabled()) {
            LOG.debug("isFinished={} {}", (Object)finished, (Object)this);
        }
        return finished;
    }

    public boolean isReady() {
        try (AutoLock ignored = this._lock.lock();){
            boolean ready = this._contentProducer.isReady();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isReady={} {}", (Object)ready, (Object)this);
            }
            boolean bl = ready;
            return bl;
        }
    }

    public void setReadListener(ReadListener readListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting read listener to {} {}", (Object)readListener, (Object)this);
        }
        if (this._readListener != null) {
            throw new IllegalStateException("ReadListener already set");
        }
        if (!this._channelState.isAsyncStarted()) {
            throw new IllegalStateException("Async not started");
        }
        this._readListener = Objects.requireNonNull(readListener);
        this._contentProducer = this._asyncContentProducer;
        if (this.isReady() && this._channelState.onReadListenerReady()) {
            this.scheduleReadListenerNotification();
        }
    }

    public boolean onContentProducible() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._contentProducer.onContentProducible();
            return bl;
        }
    }

    public int read() throws IOException {
        try (AutoLock ignored = this._lock.lock();){
            int read = this.read(this._oneByteBuffer, 0, 1);
            if (read == 0) {
                throw new IOException("unready read=0");
            }
            int n = read < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
            return n;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(null, b, off, len);
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, null, -1, -1);
    }

    private int read(ByteBuffer buffer, byte[] b, int off, int len) throws IOException {
        try (AutoLock ignored = this._lock.lock();){
            if (len == 0) {
                int n = 0;
                return n;
            }
            this._contentProducer.checkMinDataRate();
            Content.Chunk chunk = this._contentProducer.nextChunk();
            if (chunk == null) {
                throw new IllegalStateException("read on unready input");
            }
            if (chunk.hasRemaining()) {
                int read;
                int n = read = buffer == null ? this.get(chunk, b, off, len) : this.get(chunk, buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read produced {} byte(s) {}", (Object)read, (Object)this);
                }
                if (!chunk.hasRemaining()) {
                    this._contentProducer.reclaim(chunk);
                }
                int n2 = read;
                return n2;
            }
            if (Content.Chunk.isFailure(chunk)) {
                Throwable failure = chunk.getFailure();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read failure={} {}", (Object)failure, (Object)this);
                }
                throw IO.rethrow(failure);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("read at EOF, setting consumed EOF to true {}", (Object)this);
            }
            this._consumedEof = true;
            if (this.onContentProducible()) {
                this.scheduleReadListenerNotification();
            }
            int n = -1;
            return n;
        }
    }

    private void scheduleReadListenerNotification() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("scheduling ReadListener notification {}", (Object)this);
        }
        this._servletChannel.execute(this._servletChannel::handle);
    }

    public boolean hasContent() {
        try (AutoLock ignored = this._lock.lock();){
            boolean hasContent = this._contentProducer.hasChunk();
            if (LOG.isDebugEnabled()) {
                LOG.debug("hasContent={} {}", (Object)hasContent, (Object)this);
            }
            boolean bl = hasContent;
            return bl;
        }
    }

    public int available() {
        try (AutoLock ignored = this._lock.lock();){
            int available = this._contentProducer.available();
            if (LOG.isDebugEnabled()) {
                LOG.debug("available={} {}", (Object)available, (Object)this);
            }
            int n = available;
            return n;
        }
    }

    public void readCallback() {
        Content.Chunk chunk;
        try (AutoLock ignored = this._lock.lock();){
            if (!this._contentProducer.isReady()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running but not ready {}", (Object)this);
                }
                return;
            }
            chunk = this._contentProducer.nextChunk();
            if (LOG.isDebugEnabled()) {
                LOG.debug("running on content {} {}", (Object)chunk, (Object)this);
            }
        }
        if (this._readListener == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running without a read listener {}", (Object)this);
            }
            this.onContentProducible();
            return;
        }
        if (Content.Chunk.isFailure(chunk)) {
            Throwable failure = chunk.getFailure();
            if (LOG.isDebugEnabled()) {
                LOG.debug("running failure={} {}", (Object)failure, (Object)this);
            }
            this._readListener.onError(failure);
        } else if (chunk.isLast() && !chunk.hasRemaining()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running at EOF {}", (Object)this);
                }
                this._readListener.onAllDataRead();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("running failed onAllDataRead {}", (Object)this);
                }
                this._readListener.onError(x);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running has content {}", (Object)this);
            }
            try {
                this._readListener.onDataAvailable();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("running failed onDataAvailable {}", (Object)this);
                }
                this._readListener.onError(x);
            }
        }
    }

    public String toString() {
        return TypeUtil.toShortName(((Object)((Object)this)).getClass()) + "@" + ((Object)((Object)this)).hashCode() + " cs=" + String.valueOf(this._channelState) + " cp=" + String.valueOf(this._contentProducer) + " eof=" + this._consumedEof;
    }
}

