/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.StreamingErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.runtime.StreamMetadata;
import org.apache.spark.sql.execution.streaming.runtime.StreamMetadata$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000513A\u0001C\u0005\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011!1\u0004\u0001#b\u0001\n\u00039\u0004\u0002\u0003 \u0001\u0011\u000b\u0007I\u0011A \t\u0011\r\u0003\u0001R1A\u0005\u0006\u0011CQ\u0001\u0013\u0001\u0005\u0016%\u0013\u0001e\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018p\u00115fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uC*\u0011!bC\u0001\beVtG/[7f\u0015\taQ\"A\u0005tiJ,\u0017-\\5oO*\u0011abD\u0001\nKb,7-\u001e;j_:T!\u0001E\t\u0002\u0007M\fHN\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\t#%D\u0001\u0010\u0013\t\u0019sB\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\fsKN|GN^3e\u0007\",7m\u001b9pS:$(k\\8u!\t1SF\u0004\u0002(WA\u0011\u0001fG\u0007\u0002S)\u0011!fF\u0001\u0007yI|w\u000e\u001e \n\u00051Z\u0012A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u000e\u0002\rqJg.\u001b;?)\r\u0011D'\u000e\t\u0003g\u0001i\u0011!\u0003\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006I\r\u0001\r!J\u0001\n_\u001a47/\u001a;M_\u001e,\u0012\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003w-\tQb\u00195fG.\u0004x.\u001b8uS:<\u0017BA\u001f;\u00051yeMZ:fiN+\u0017\u000fT8h\u0003%\u0019w.\\7ji2{w-F\u0001A!\tI\u0014)\u0003\u0002Cu\tI1i\\7nSRdunZ\u0001\u000fgR\u0014X-Y7NKR\fG-\u0019;b+\u0005)\u0005CA\u001aG\u0013\t9\u0015B\u0001\bTiJ,\u0017-\\'fi\u0006$\u0017\r^1\u0002\u001d\rDWmY6q_&tGOR5mKR\u0011QE\u0013\u0005\u0006\u0017\u001e\u0001\r!J\u0001\u0005]\u0006lW\r")
public class StreamingQueryCheckpointMetadata {
    private OffsetSeqLog offsetLog;
    private CommitLog commitLog;
    private StreamMetadata streamMetadata;
    private final SparkSession sparkSession;
    private final String resolvedCheckpointRoot;
    private volatile byte bitmap$0;

    private OffsetSeqLog offsetLog$lzycompute() {
        StreamingQueryCheckpointMetadata streamingQueryCheckpointMetadata = this;
        synchronized (streamingQueryCheckpointMetadata) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.offsetLog = new OffsetSeqLog(this.sparkSession, this.checkpointFile(StreamingCheckpointConstants$.MODULE$.DIR_NAME_OFFSETS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.offsetLog;
    }

    public OffsetSeqLog offsetLog() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.offsetLog$lzycompute();
        }
        return this.offsetLog;
    }

    private CommitLog commitLog$lzycompute() {
        StreamingQueryCheckpointMetadata streamingQueryCheckpointMetadata = this;
        synchronized (streamingQueryCheckpointMetadata) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.commitLog = new CommitLog(this.sparkSession, this.checkpointFile(StreamingCheckpointConstants$.MODULE$.DIR_NAME_COMMITS()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commitLog;
    }

    public CommitLog commitLog() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commitLog$lzycompute();
        }
        return this.commitLog;
    }

    private StreamMetadata streamMetadata$lzycompute() {
        StreamingQueryCheckpointMetadata streamingQueryCheckpointMetadata = this;
        synchronized (streamingQueryCheckpointMetadata) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Path metadataPath = new Path(this.checkpointFile(StreamingCheckpointConstants$.MODULE$.DIR_NAME_METADATA()));
                Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConf();
                this.streamMetadata = (StreamMetadata)StreamMetadata$.MODULE$.read(metadataPath, hadoopConf).getOrElse((Function0 & Serializable)() -> {
                    if (BoxesRunTime.unboxToBoolean((Object)$this.sparkSession.conf().get(SQLConf$.MODULE$.STREAMING_CHECKPOINT_VERIFY_METADATA_EXISTS()))) {
                        boolean hasOffsetData = this.offsetLog().getLatestBatchId().isDefined();
                        boolean hasCommitData = this.commitLog().getLatestBatchId().isDefined();
                        if (hasOffsetData || hasCommitData) {
                            throw StreamingErrors$.MODULE$.missingMetadataFile($this.resolvedCheckpointRoot);
                        }
                    }
                    StreamMetadata newMetadata = new StreamMetadata(UUID.randomUUID().toString());
                    StreamMetadata$.MODULE$.write(newMetadata, metadataPath, hadoopConf);
                    return newMetadata;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.streamMetadata;
    }

    public final StreamMetadata streamMetadata() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.streamMetadata$lzycompute();
        }
        return this.streamMetadata;
    }

    public final String checkpointFile(String name) {
        return new Path(new Path(this.resolvedCheckpointRoot), name).toString();
    }

    public StreamingQueryCheckpointMetadata(SparkSession sparkSession, String resolvedCheckpointRoot) {
        this.sparkSession = sparkSession;
        this.resolvedCheckpointRoot = resolvedCheckpointRoot;
    }
}

