/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBLogFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBSstFile;

public final class RocksDBImmutableFile$ {
    public static final RocksDBImmutableFile$ MODULE$ = new RocksDBImmutableFile$();
    private static final String SST_FILES_DFS_SUBDIR = "SSTs";
    private static final String LOG_FILES_DFS_SUBDIR = "logs";
    private static final String LOG_FILES_LOCAL_SUBDIR = "archive";

    public String SST_FILES_DFS_SUBDIR() {
        return SST_FILES_DFS_SUBDIR;
    }

    public String LOG_FILES_DFS_SUBDIR() {
        return LOG_FILES_DFS_SUBDIR;
    }

    public String LOG_FILES_LOCAL_SUBDIR() {
        return LOG_FILES_LOCAL_SUBDIR;
    }

    public RocksDBImmutableFile apply(String localFileName, String dfsFileName, long sizeBytes) {
        if (this.isSstFile(localFileName)) {
            return new RocksDBSstFile(localFileName, dfsFileName, sizeBytes);
        }
        if (this.isLogFile(localFileName)) {
            return new RocksDBLogFile(localFileName, dfsFileName, sizeBytes);
        }
        return null;
    }

    public boolean isSstFile(String fileName) {
        return fileName.endsWith(".sst");
    }

    public boolean isLogFile(String fileName) {
        return fileName.endsWith(".log");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isArchivedLogFile(File file) {
        if (!this.isLogFile(file.getName())) return false;
        String string = file.getParentFile().getName();
        String string2 = this.LOG_FILES_LOCAL_SUBDIR();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isImmutableFile(File file) {
        return this.isSstFile(file.getName()) || this.isArchivedLogFile(file);
    }

    private RocksDBImmutableFile$() {
    }
}

