/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.SparkThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\tk\u0001\u0011\t\u0011)A\u0005U!)a\u0007\u0001C\u0001o!)a\u0007\u0001C\u0001w!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002&\u0001A\u0003%a\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rU\u0003\u0001\u0015!\u0003N\u0011\u001d1\u0006A1A\u0005\u0002]Caa\u0017\u0001!\u0002\u0013A\u0006\"\u0002/\u0001\t\u0003i\u0006bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003+\u0001A\u0011\u0001\r^\u0011!\tY\u0002\u0001C\u00011\u0005u\u0001\u0002CA\u0013\u0001\u0011\u0005\u0001$a\n\t\u0011\u0005M\u0002\u0001\"\u0001\u0019\u0003kA\u0001\"!\u0010\u0001\t\u0003A\u0012qH\u0004\b\u0003\u0003B\u0002\u0012AA\"\r\u00199\u0002\u0004#\u0001\u0002F!1ag\u0005C\u0001\u0003\u000fBa!!\u0013\u0014\t\u0003Y\u0004bBA%'\u0011\u0005\u00111\n\u0002\f\u001f\n\u001cXM\u001d<bi&|gN\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fAA\\1nKV\t!\u0006\u0005\u0002,e9\u0011A\u0006\r\t\u0003[\u0011j\u0011A\f\u0006\u0003_\u0001\na\u0001\u0010:p_Rt\u0014BA\u0019%\u0003\u0019\u0001&/\u001a3fM&\u00111\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E\"\u0013!\u00028b[\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00029uA\u0011\u0011\bA\u0007\u00021!)\u0001f\u0001a\u0001UQ\t\u0001(\u0001\u0007jgJ+w-[:uKJ,G-F\u0001?!\ty\u0004*D\u0001A\u0015\t\t%)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0007\u0012\u000b!bY8oGV\u0014(/\u001a8u\u0015\t)e)\u0001\u0003vi&d'\"A$\u0002\t)\fg/Y\u0005\u0003\u0013\u0002\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D5t%\u0016<\u0017n\u001d;fe\u0016$\u0007%A\u0004qe>l\u0017n]3\u0016\u00035\u00032A\u0014)S\u001b\u0005y%BA\"%\u0013\t\tvJA\u0004Qe>l\u0017n]3\u0011\u0005e\u001a\u0016B\u0001+\u0019\u0005\r\u0011vn^\u0001\taJ|W.[:fA\u00051a-\u001e;ve\u0016,\u0012\u0001\u0017\t\u0004\u001df\u0013\u0016B\u0001.P\u0005\u00191U\u000f^;sK\u00069a-\u001e;ve\u0016\u0004\u0013aA4fiV\ta\f\u0005\u0003,?*\n\u0017B\u000115\u0005\ri\u0015\r\u001d\t\u0003G\tL!a\u0019\u0013\u0003\u0007\u0005s\u0017\u0010K\u0002\fKF\u00042a\t4i\u0013\t9GE\u0001\u0004uQJ|wo\u001d\t\u0003S:t!A\u001b7\u000f\u00055Z\u0017\"A\u0013\n\u00055$\u0013a\u00029bG.\fw-Z\u0005\u0003_B\u0014A#\u00138uKJ\u0014X\u000f\u001d;fI\u0016C8-\u001a9uS>t'BA7%c\u0011)#/a\u0001+\u0005MD\bC\u0001;x\u001b\u0005)(B\u0001<G\u0003\u0011a\u0017M\\4\n\u0005M*8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018\u0001B7fi\u0006T!A \u0013\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0002m\u0014!\u0002Z3gCVdG/\u0011:hC\t\t)!\u0001\u0001\u0002\u0013\u001d,G/Q:KCZ\fWCAA\u0006!\u0019\ti!a\u0004+C6\tA)\u0003\u0002a\t\"\"A\"ZA\nc\u0011)#/a\u0001\u0002\u0015\u001d,Go\u0014:F[B$\u0018\u0010\u000b\u0003\u000eK\u0006e\u0011\u0007B\u0013s\u0003\u0007\ta\"\\1sWJ+w-[:uKJ,G\r\u0006\u0002\u0002 A\u00191%!\t\n\u0007\u0005\rBE\u0001\u0003V]&$\u0018aE:fi6+GO]5dg\u0006sGMT8uS\u001aLH\u0003BA\u0015\u0003_\u00012aIA\u0016\u0013\r\ti\u0003\n\u0002\b\u0005>|G.Z1o\u0011\u0019\t\td\u0004a\u0001%\u00069Q.\u001a;sS\u000e\u001c\u0018!D4fiJ{wo\u0014:F[B$\u00180\u0006\u0002\u00028A!1%!\u000fS\u0013\r\tY\u0004\n\u0002\u0007\u001fB$\u0018n\u001c8\u0002\r\u001d,GOU8x+\u0005\u0011\u0016aC(cg\u0016\u0014h/\u0019;j_:\u0004\"!O\n\u0014\u0005M\u0011CCAA\"\u0003\u0015\t\u0007\u000f\u001d7z)\rA\u0014Q\n\u0005\u0006QY\u0001\rA\u000b")
public class Observation {
    private final String name;
    private final AtomicBoolean isRegistered;
    private final Promise<Row> promise;
    private final Future<Row> future;

    public static Observation apply(String name) {
        return Observation$.MODULE$.apply(name);
    }

    public static Observation apply() {
        return Observation$.MODULE$.apply();
    }

    public String name() {
        return this.name;
    }

    private AtomicBoolean isRegistered() {
        return this.isRegistered;
    }

    private Promise<Row> promise() {
        return this.promise;
    }

    public Future<Row> future() {
        return this.future;
    }

    public Map<String, Object> get() throws InterruptedException {
        Row row = this.getRow();
        if (row == null || row.schema() == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return row.getValuesMap((Seq<String>)((Seq)row.schema().map((Function1 & Serializable)x$1 -> x$1.name())));
    }

    public java.util.Map<String, Object> getAsJava() throws InterruptedException {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.get()).asJava();
    }

    public Map<String, Object> getOrEmpty() throws InterruptedException {
        Row row = (Row)this.getRowOrEmpty().getOrElse((Function0 & Serializable)() -> Row$.MODULE$.empty());
        return row.getValuesMap((Seq<String>)((Seq)row.schema().map((Function1 & Serializable)x$2 -> x$2.name())));
    }

    public void markRegistered() {
        if (!this.isRegistered().compareAndSet(false, true)) {
            throw new IllegalArgumentException("An Observation can be used with a Dataset only once");
        }
    }

    public boolean setMetricsAndNotify(Row metrics) {
        return this.promise().trySuccess((Object)metrics);
    }

    public Option<Row> getRowOrEmpty() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (Row)SparkThreadUtils$.MODULE$.awaitResult(this.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).millis())).toOption();
    }

    public Row getRow() {
        return (Row)SparkThreadUtils$.MODULE$.awaitResult(this.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public Observation(String name) {
        this.name = name;
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name)), (Function0 & Serializable)() -> "Name must not be empty");
        this.isRegistered = new AtomicBoolean();
        this.promise = Promise$.MODULE$.apply();
        this.future = this.promise().future();
    }

    public Observation() {
        this(UUID.randomUUID().toString());
    }
}

