/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.FMClassificationModel;
import org.apache.spark.ml.classification.FMClassifier$;
import org.apache.spark.ml.classification.FMClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FactorizationMachines;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\r\u001b\u0001\u0015B\u0001\"\u0013\u0001\u0003\u0006\u0004%\tE\u0013\u0005\tC\u0002\u0011\t\u0011)A\u0005\u0017\")1\r\u0001C\u0001I\")1\r\u0001C\u0001Q\")!\u000e\u0001C\u0001W\")A\u000f\u0001C\u0001k\")1\u0010\u0001C\u0001y\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!a\u0013\u0001\t#\ni\u0005C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011\u0011\u0018\u0001\u0005B\u0005mvaBAf5!\u0005\u0011Q\u001a\u0004\u00073iA\t!a4\t\r\r,B\u0011AAw\u0011\u001d\ty/\u0006C!\u0003cD\u0011\"!?\u0016\u0003\u0003%I!a?\u0003\u0019\u0019k5\t\\1tg&4\u0017.\u001a:\u000b\u0005ma\u0012AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003;y\t!!\u001c7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001MQRTh\u0011\t\u0006O!R\u0003'M\u0007\u00025%\u0011\u0011F\u0007\u0002\u0018!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u000f\u0002\r1Lg.\u00197h\u0013\tyCF\u0001\u0004WK\u000e$xN\u001d\t\u0003O\u0001\u0001\"a\n\u001a\n\u0005MR\"!\u0006$N\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003kaj\u0011A\u000e\u0006\u0003oq\t!B]3he\u0016\u001c8/[8o\u0013\tIdGA\u000bGC\u000e$xN]5{CRLwN\\'bG\"Lg.Z:\u0011\u0005\u001dZ\u0014B\u0001\u001f\u001b\u0005I1Uj\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0011\u0005y\nU\"A \u000b\u0005\u0001c\u0012\u0001B;uS2L!AQ \u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mKB\u0011AiR\u0007\u0002\u000b*\u0011aIH\u0001\tS:$XM\u001d8bY&\u0011\u0001*\u0012\u0002\b\u0019><w-\u001b8h\u0003\r)\u0018\u000eZ\u000b\u0002\u0017B\u0011A*\u0016\b\u0003\u001bN\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u0013\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u000b\u0006fA\u0001Z?B\u0011!,X\u0007\u00027*\u0011ALH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00010\\\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0017!B\u001a/a9\u0002\u0014\u0001B;jI\u0002B3AA-`\u0003\u0019a\u0014N\\5u}Q\u0011\u0001'\u001a\u0005\u0006\u0013\u000e\u0001\ra\u0013\u0015\u0004Kf{\u0006fA\u0002Z?R\t\u0001\u0007K\u0002\u00053~\u000bQb]3u\r\u0006\u001cGo\u001c:TSj,GC\u00017n\u001b\u0005\u0001\u0001\"\u00028\u0006\u0001\u0004y\u0017!\u0002<bYV,\u0007C\u00019r\u001b\u0005\t\u0016B\u0001:R\u0005\rIe\u000e\u001e\u0015\u0004\u000be{\u0016aD:fi\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0015\u000514\b\"\u00028\u0007\u0001\u00049\bC\u00019y\u0013\tI\u0018KA\u0004C_>dW-\u00198)\u0007\u0019Iv,\u0001\u0007tKR4\u0015\u000e\u001e'j]\u0016\f'\u000f\u0006\u0002m{\")an\u0002a\u0001o\"\u001aq!W0\u0002\u0017M,GOU3h!\u0006\u0014\u0018-\u001c\u000b\u0004Y\u0006\r\u0001B\u00028\t\u0001\u0004\t)\u0001E\u0002q\u0003\u000fI1!!\u0003R\u0005\u0019!u.\u001e2mK\"\u001a\u0001\"W0\u0002)M,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o)\ra\u0017\u0011\u0003\u0005\u0007]&\u0001\r!!\u0002)\u0007%Iv,\u0001\u0006tKRLe.\u001b;Ti\u0012$2\u0001\\A\r\u0011\u0019q'\u00021\u0001\u0002\u0006!\u001a!\"W0\u0002\u0015M,G/T1y\u0013R,'\u000fF\u0002m\u0003CAQA\\\u0006A\u0002=D3aC-`\u0003-\u0019X\r^*uKB\u001c\u0016N_3\u0015\u00071\fI\u0003\u0003\u0004o\u0019\u0001\u0007\u0011Q\u0001\u0015\u0004\u0019e{\u0016AB:fiR{G\u000eF\u0002m\u0003cAaA\\\u0007A\u0002\u0005\u0015\u0001fA\u0007Z?\u0006I1/\u001a;T_24XM\u001d\u000b\u0004Y\u0006e\u0002\"\u00028\u000f\u0001\u0004Y\u0005f\u0001\bZ?\u000691/\u001a;TK\u0016$Gc\u00017\u0002B!1an\u0004a\u0001\u0003\u0007\u00022\u0001]A#\u0013\r\t9%\u0015\u0002\u0005\u0019>tw\rK\u0002\u00103~\u000bQ\u0001\u001e:bS:$2!MA(\u0011\u001d\t\t\u0006\u0005a\u0001\u0003'\nq\u0001Z1uCN,G\u000f\r\u0003\u0002V\u0005\u0015\u0004CBA,\u0003;\n\t'\u0004\u0002\u0002Z)\u0019\u00111\f\u0010\u0002\u0007M\fH.\u0003\u0003\u0002`\u0005e#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003G\n)\u0007\u0004\u0001\u0005\u0019\u0005\u001d\u0014qJA\u0001\u0002\u0003\u0015\t!!\u001b\u0003\u0007}#\u0013'\u0005\u0003\u0002l\u0005E\u0004c\u00019\u0002n%\u0019\u0011qN)\u0003\u000f9{G\u000f[5oOB\u0019\u0001/a\u001d\n\u0007\u0005U\u0014KA\u0002B]f\f1b\u0019:fCR,Wj\u001c3fYRY\u0011'a\u001f\u0002\b\u0006-\u0015qRAM\u0011\u001d\t\t&\u0005a\u0001\u0003{\u0002D!a \u0002\u0004B1\u0011qKA/\u0003\u0003\u0003B!a\u0019\u0002\u0004\u0012a\u0011QQA>\u0003\u0003\u0005\tQ!\u0001\u0002j\t\u0019q\f\n\u001a\t\u000f\u0005%\u0015\u00031\u0001\u0002\u0006\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0005\u0007\u0003\u001b\u000b\u0002\u0019\u0001\u0016\u0002\r1Lg.Z1s\u0011\u001d\t\t*\u0005a\u0001\u0003'\u000bqAZ1di>\u00148\u000fE\u0002,\u0003+K1!a&-\u0005\u0019i\u0015\r\u001e:jq\"9\u00111T\tA\u0002\u0005u\u0015\u0001E8cU\u0016\u001cG/\u001b<f\u0011&\u001cHo\u001c:z!\u0015\u0001\u0018qTA\u0003\u0013\r\t\t+\u0015\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0005G>\u0004\u0018\u0010F\u00021\u0003OCq!!+\u0013\u0001\u0004\tY+A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002.\u0006MVBAAX\u0015\r\t\t\fH\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003k\u000byK\u0001\u0005QCJ\fW.T1qQ\r\u0011\u0012lX\u0001\u0012KN$\u0018.\\1uK6{G-\u001a7TSj,G\u0003BA\"\u0003{Cq!!\u0015\u0014\u0001\u0004\ty\f\r\u0003\u0002B\u0006\u0015\u0007CBA,\u0003;\n\u0019\r\u0005\u0003\u0002d\u0005\u0015G\u0001DAd\u0003{\u000b\t\u0011!A\u0003\u0002\u0005%$aA0%g!\u001a\u0001!W0\u0002\u0019\u0019k5\t\\1tg&4\u0017.\u001a:\u0011\u0005\u001d*2cB\u000b\u0002R\u0006]\u0017Q\u001c\t\u0004a\u0006M\u0017bAAk#\n1\u0011I\\=SK\u001a\u0004BAPAma%\u0019\u00111\\ \u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018AA5p\u0015\t\t9/\u0001\u0003kCZ\f\u0017\u0002BAv\u0003C\u0014AbU3sS\u0006d\u0017N_1cY\u0016$\"!!4\u0002\t1|\u0017\r\u001a\u000b\u0004a\u0005M\bBBA{/\u0001\u00071*\u0001\u0003qCRD\u0007fA\fZ?\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q \t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AAs\u0003\u0011a\u0017M\\4\n\t\t\u001d!\u0011\u0001\u0002\u0007\u001f\nTWm\u0019;)\u0007UIv\fK\u0002\u00153~\u0003")
public class FMClassifier
extends ProbabilisticClassifier<org.apache.spark.ml.linalg.Vector, FMClassifier, FMClassificationModel>
implements FactorizationMachines,
FMClassifierParams,
DefaultParamsWritable {
    private final String uid;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMClassifier load(String path) {
        return FMClassifier$.MODULE$.load(path);
    }

    public static MLReader<FMClassifier> read() {
        return FMClassifier$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector initCoefficients(int numFeatures) {
        return FactorizationMachines.initCoefficients$(this, numFeatures);
    }

    @Override
    public Tuple2<org.apache.spark.ml.linalg.Vector, double[]> trainImpl(RDD<Tuple2<Object, Vector>> data, int numFeatures, String loss) {
        return FactorizationMachines.trainImpl$(this, data, numFeatures, loss);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public FMClassifier setFactorSize(int value) {
        return (FMClassifier)this.set(this.factorSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMClassifier setFitIntercept(boolean value) {
        return (FMClassifier)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMClassifier setFitLinear(boolean value) {
        return (FMClassifier)this.set(this.fitLinear(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMClassifier setRegParam(double value) {
        return (FMClassifier)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setMiniBatchFraction(double value) {
        return (FMClassifier)this.set(this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setInitStd(double value) {
        return (FMClassifier)this.set(this.initStd(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setMaxIter(int value) {
        return (FMClassifier)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMClassifier setStepSize(double value) {
        return (FMClassifier)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setTol(double value) {
        return (FMClassifier)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMClassifier setSolver(String value) {
        return (FMClassifier)this.set(this.solver(), value);
    }

    public FMClassifier setSeed(long value) {
        return (FMClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public FMClassificationModel train(Dataset<?> dataset) {
        return (FMClassificationModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            int numClasses = 2;
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable)() -> this.getClass().getSimpleName() + ".train() called with non-matching numClasses and thresholds.length. numClasses=" + numClasses + ", but thresholds has length " + this.$(this.thresholds()).length);
            }
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.factorSize(), this.fitIntercept(), this.fitLinear(), this.regParam(), this.miniBatchFraction(), this.initStd(), this.maxIter(), this.stepSize(), this.tol(), this.solver(), this.thresholds()}));
            instr.logNumClasses(numClasses);
            int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            instr.logNumFeatures(numFeatures);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD data = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2))), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
                    Object l = ((SeqOps)some.get()).apply(0);
                    Object v = ((SeqOps)some.get()).apply(1);
                    if (l instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)l);
                        if (v instanceof org.apache.spark.ml.linalg.Vector) {
                            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
                            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)Vectors$.MODULE$.fromML(vector));
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).setName("training instances");
            Object object = handlePersistence ? data.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Tuple2<org.apache.spark.ml.linalg.Vector, double[]> tuple2 = this.trainImpl((RDD<Tuple2<Object, Vector>>)data, numFeatures, FactorizationMachines$.MODULE$.LogisticLoss());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            org.apache.spark.ml.linalg.Vector coefficients = (org.apache.spark.ml.linalg.Vector)tuple2._1();
            double[] objectiveHistory = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)coefficients, (Object)objectiveHistory);
            org.apache.spark.ml.linalg.Vector coefficients2 = (org.apache.spark.ml.linalg.Vector)tuple22._1();
            double[] objectiveHistory2 = (double[])tuple22._2();
            Tuple3<Object, org.apache.spark.ml.linalg.Vector, Matrix> tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(coefficients2, numFeatures, BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitLinear())));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            org.apache.spark.ml.linalg.Vector linear = (org.apache.spark.ml.linalg.Vector)tuple3._2();
            Matrix factors = (Matrix)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            org.apache.spark.ml.linalg.Vector linear2 = (org.apache.spark.ml.linalg.Vector)tuple32._2();
            Matrix factors2 = (Matrix)tuple32._3();
            Object object2 = handlePersistence ? data.unpersist(data.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.createModel(dataset, intercept2, linear2, factors2, objectiveHistory2);
        });
    }

    private FMClassificationModel createModel(Dataset<?> dataset, double intercept, org.apache.spark.ml.linalg.Vector linear, Matrix factors, double[] objectiveHistory) {
        FMClassificationModel model = this.copyValues(new FMClassificationModel(this.uid(), intercept, linear, factors), this.copyValues$default$2());
        model.createSummary(dataset, objectiveHistory);
        return model;
    }

    @Override
    public FMClassifier copy(ParamMap extra) {
        return (FMClassifier)this.defaultCopy(extra);
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        size += org.apache.spark.ml.linalg.Vectors$.MODULE$.getDenseSize((long)numFeatures);
        return size += Matrices$.MODULE$.getDenseSize((long)numFeatures, (long)BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())));
    }

    public FMClassifier(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        FactorizationMachines.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public FMClassifier() {
        this(Identifiable$.MODULE$.randomUID("fmc"));
    }
}

