-- CREATE VIEW with DEFAULT COLLATION
DROP VIEW IF EXISTS v;
CREATE VIEW v DEFAULT COLLATION UNICODE AS SELECT 'a';
SELECT * FROM v;

DROP VIEW IF EXISTS v;
CREATE VIEW v DEFAULT COLLATION UTF8_LCASE AS SELECT 'a' AS c1;
SELECT COUNT(*) FROM v WHERE c1 = 'A';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('a'), ('A');
CREATE VIEW v DEFAULT COLLATION SR_AI_CI AS SELECT c1 FROM t WHERE 'ć' = 'č';
SELECT COUNT(*) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'A';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('ć'), ('č');
CREATE VIEW v DEFAULT COLLATION UNICODE AS SELECT CAST(c1 AS STRING COLLATE SR_AI) FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'c';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('ć'), ('č');
CREATE VIEW v DEFAULT COLLATION UNICODE AS SELECT CAST(c1 AS STRING COLLATE SR_AI) FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'c';

DROP VIEW IF EXISTS v;
CREATE VIEW v DEFAULT COLLATION UTF8_LCASE
AS SELECT 'a' AS c1, (SELECT (SELECT CASE 'a' = 'A' WHEN TRUE THEN 'a' ELSE 'b' END) WHERE (SELECT 'b' WHERE 'c' = 'C') = 'B') AS c2, 'c';
SELECT COUNT(*) FROM v WHERE c1 = 'A';
SELECT COUNT(*) FROM v WHERE c2 = 'a';
SELECT COUNT(*) FROM v WHERE c2 = 'b';
SELECT * FROM v;

-- CREATE OR REPLACE VIEW with DEFAULT COLLATION
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING, c2 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('a', 'a'), ('A', 'A'), ('b', 'b');
CREATE OR REPLACE VIEW v DEFAULT COLLATION sr_ci_ai AS SELECT *, 'ć' AS c3 FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT DISTINCT COLLATION(c2) FROM v;
SELECT DISTINCT COLLATION(c3) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'A';
SELECT COUNT(*) FROM v WHERE c2 = 'a';
SELECT COUNT(*) FROM v WHERE c3 = 'Č';

-- ALTER VIEW check default collation
DROP VIEW IF EXISTS v;
CREATE VIEW v DEFAULT COLLATION UTF8_LCASE AS SELECT 1;
ALTER VIEW v AS SELECT 'a' AS c1, 'b' AS c2;
SELECT COLLATION(c1) FROM v;
SELECT COLLATION(c2) FROM v;
ALTER VIEW v AS SELECT 'c' AS c3 WHERE 'a' = 'A';
SELECT COLLATION(c3) FROM v;

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE, c2 STRING, c3 INT);
INSERT INTO t VALUES ('a', 'b', 1);
CREATE VIEW v DEFAULT COLLATION sr_AI_CI AS SELECT 'a' AS c1;
ALTER VIEW v AS
    SELECT *, 'c' AS c4, (SELECT (SELECT CASE 'š' = 'S' WHEN TRUE THEN 'd' ELSE 'b' END)) AS c5
    FROM t
    WHERE c1 = 'A' AND 'ć' = 'Č';
SELECT COLLATION(c4) FROM v;
SELECT COLLATION(c5) FROM v;
SELECT c5 FROM v;

-- CREATE TEMPORARY VIEW with DEFAULT COLLATION
DROP VIEW IF EXISTS v;
CREATE TEMPORARY VIEW v DEFAULT COLLATION UNICODE AS SELECT 'a';
SELECT * FROM v;

DROP VIEW IF EXISTS v;
CREATE TEMPORARY VIEW v DEFAULT COLLATION UTF8_LCASE AS SELECT 'a' AS c1;
SELECT COUNT(*) FROM v WHERE c1 = 'A';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('a'), ('A');
CREATE TEMPORARY VIEW v DEFAULT COLLATION SR_AI_CI AS SELECT c1 FROM t WHERE 'ć' = 'č';
SELECT COUNT(*) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'A';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('ć'), ('č');
CREATE TEMPORARY VIEW v DEFAULT COLLATION UNICODE AS SELECT CAST(c1 AS STRING COLLATE SR_AI) FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'c';

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('ć'), ('č');
CREATE TEMPORARY VIEW v DEFAULT COLLATION UNICODE AS SELECT CAST(c1 AS STRING COLLATE SR_AI) FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'c';

DROP VIEW IF EXISTS v;
CREATE TEMPORARY VIEW v DEFAULT COLLATION UTF8_LCASE
AS SELECT 'a' AS c1, (SELECT (SELECT CASE 'a' = 'A' WHEN TRUE THEN 'a' ELSE 'b' END) WHERE (SELECT 'b' WHERE 'c' = 'C') = 'B') AS c2, 'c';
SELECT COUNT(*) FROM v WHERE c1 = 'A';
SELECT COUNT(*) FROM v WHERE c2 = 'a';
SELECT COUNT(*) FROM v WHERE c2 = 'b';
SELECT * FROM v;

-- CREATE OR REPLACE TEMPORARY VIEW with DEFAULT COLLATION
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING, c2 STRING COLLATE UTF8_LCASE);
INSERT INTO t VALUES ('a', 'a'), ('A', 'A'), ('b', 'b');
CREATE OR REPLACE TEMPORARY VIEW v DEFAULT COLLATION sr_ci_ai AS SELECT *, 'ć' AS c3 FROM t;
SELECT DISTINCT COLLATION(c1) FROM v;
SELECT DISTINCT COLLATION(c2) FROM v;
SELECT DISTINCT COLLATION(c3) FROM v;
SELECT COUNT(*) FROM v WHERE c1 = 'A';
SELECT COUNT(*) FROM v WHERE c2 = 'a';
SELECT COUNT(*) FROM v WHERE c3 = 'Č';

-- ALTER TEMPORARY VIEW check default collation
DROP VIEW IF EXISTS v;
CREATE TEMPORARY VIEW v DEFAULT COLLATION UTF8_LCASE AS SELECT 1;
ALTER VIEW v AS SELECT 'a' AS c1, 'b' AS c2;
SELECT COLLATION(c1) FROM v;
SELECT COLLATION(c2) FROM v;
ALTER VIEW v AS SELECT 'c' AS c3 WHERE 'a' = 'A';
SELECT COLLATION(c3) FROM v;

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
CREATE TABLE t (c1 STRING COLLATE UTF8_LCASE, c2 STRING, c3 INT);
INSERT INTO t VALUES ('a', 'b', 1);
CREATE TEMPORARY VIEW v DEFAULT COLLATION sr_AI_CI AS SELECT 'a' AS c1;
ALTER VIEW v AS
    SELECT *, 'c' AS c4, (SELECT (SELECT CASE 'š' = 'S' WHEN TRUE THEN 'd' ELSE 'b' END)) AS c5
    FROM t
    WHERE c1 = 'A' AND 'ć' = 'Č';
SELECT COLLATION(c4) FROM v;
SELECT COLLATION(c5) FROM v;
SELECT c5 FROM v;

DROP VIEW IF EXISTS v;
DROP TABLE IF EXISTS t;
