/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import org.sparkproject.jetty.client.AbstractConnectionPool;
import org.sparkproject.jetty.client.ConnectionPool;
import org.sparkproject.jetty.client.HttpClient;
import org.sparkproject.jetty.client.HttpDestination;
import org.sparkproject.jetty.client.Origin;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;

public class MultiplexHttpDestination
extends HttpDestination
implements HttpDestination.Multiplexed {
    public MultiplexHttpDestination(HttpClient client, Origin origin) {
        this(client, origin, false);
    }

    public MultiplexHttpDestination(HttpClient client, Origin origin, boolean intrinsicallySecure) {
        super(client, origin, intrinsicallySecure);
    }

    @ManagedAttribute(value="The maximum number of concurrent requests per connection")
    public int getMaxRequestsPerConnection() {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof AbstractConnectionPool) {
            return ((AbstractConnectionPool)connectionPool).getMaxMultiplex();
        }
        return 1;
    }

    @Override
    public void setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        ConnectionPool connectionPool = this.getConnectionPool();
        if (connectionPool instanceof AbstractConnectionPool) {
            ((AbstractConnectionPool)connectionPool).setMaxMultiplex(maxRequestsPerConnection);
        }
    }
}

