/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DeployMessages$RequestWorkerState$;
import org.apache.spark.deploy.ExecutorState$;
import org.apache.spark.deploy.JsonProtocol$;
import org.apache.spark.deploy.StandaloneResourceUtils$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.worker.DriverRunner;
import org.apache.spark.deploy.worker.ExecutorRunner;
import org.apache.spark.deploy.worker.ui.WorkerWebUI;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.json4s.JValue;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005\u0005=a!\u0002\u0006\f\u0001-9\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000f\u001d\u0002!\u0019!C\u0005Q!1q\u0006\u0001Q\u0001\n%BQ\u0001\r\u0001\u0005BEBQ\u0001\u0012\u0001\u0005\n\u0015CQ\u0001\u001a\u0001\u0005\u0002\u0015DQA\u001e\u0001\u0005\u0002]DQA \u0001\u0005\u0002}\u0014!bV8sW\u0016\u0014\b+Y4f\u0015\taQ\"\u0001\u0002vS*\u0011abD\u0001\u0007o>\u00148.\u001a:\u000b\u0005A\t\u0012A\u00023fa2|\u0017P\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h'\t\u0001\u0001\u0004\u0005\u0002\u001a75\t!D\u0003\u0002\r#%\u0011AD\u0007\u0002\n/\u0016\u0014W+\u0013)bO\u0016\fa\u0001]1sK:$8\u0001\u0001\t\u0003A\u0005j\u0011aC\u0005\u0003E-\u00111bV8sW\u0016\u0014x+\u001a2V\u0013\u00061A(\u001b8jiz\"\"!\n\u0014\u0011\u0005\u0001\u0002\u0001\"B\u000f\u0003\u0001\u0004y\u0012AD<pe.,'/\u00128ea>Lg\u000e^\u000b\u0002SA\u0011!&L\u0007\u0002W)\u0011A&E\u0001\u0004eB\u001c\u0017B\u0001\u0018,\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fqb^8sW\u0016\u0014XI\u001c3q_&tG\u000fI\u0001\u000be\u0016tG-\u001a:Kg>tGC\u0001\u001a9!\t\u0019d'D\u00015\u0015\t)T#\u0001\u0004kg>tGg]\u0005\u0003oQ\u0012aA\u0013,bYV,\u0007\"B\u001d\u0006\u0001\u0004Q\u0014a\u0002:fcV,7\u000f\u001e\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\u001b;ua*\u0011q\bQ\u0001\bg\u0016\u0014h\u000f\\3u\u0015\u0005\t\u0015a\u00026bW\u0006\u0014H/Y\u0005\u0003\u0007r\u0012!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\u0006abm\u001c:nCR<vN]6feJ+7o\\;sG\u0016\u001cH)\u001a;bS2\u001cHC\u0001$T!\t9\u0005K\u0004\u0002I\u001dB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JH\u0001\u0007yI|w\u000e\u001e \u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0002\rA\u0013X\rZ3g\u0013\t\t&K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001f2CQ\u0001\u0016\u0004A\u0002U\u000b1b^8sW\u0016\u00148\u000b^1uKB\u0011a+\u0019\b\u0003/~s!\u0001\u00170\u000f\u0005ekfB\u0001.]\u001d\tI5,C\u0001\u0017\u0013\t!R#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003A>\ta\u0002R3qY>LX*Z:tC\u001e,7/\u0003\u0002cG\n\u0019rk\u001c:lKJ\u001cF/\u0019;f%\u0016\u001c\bo\u001c8tK*\u0011\u0001mD\u0001\u0007e\u0016tG-\u001a:\u0015\u0005\u0019,\bcA4m_:\u0011\u0001N\u001b\b\u0003\u0013&L\u0011!T\u0005\u0003W2\u000bq\u0001]1dW\u0006<W-\u0003\u0002n]\n\u00191+Z9\u000b\u0005-d\u0005C\u00019t\u001b\u0005\t(B\u0001:M\u0003\rAX\u000e\\\u0005\u0003iF\u0014AAT8eK\")\u0011h\u0002a\u0001u\u0005YQ\r_3dkR|'OU8x)\t1\u0007\u0010C\u0003z\u0011\u0001\u0007!0\u0001\u0005fq\u0016\u001cW\u000f^8s!\tYH0D\u0001\u000e\u0013\tiXB\u0001\bFq\u0016\u001cW\u000f^8s%Vtg.\u001a:\u0002\u0013\u0011\u0014\u0018N^3s%><H#\u00024\u0002\u0002\u0005\u0015\u0001BBA\u0002\u0013\u0001\u0007a)\u0001\u0005x_J\\WM]%e\u0011\u001d\t9!\u0003a\u0001\u0003\u0013\ta\u0001\u001a:jm\u0016\u0014\bcA>\u0002\f%\u0019\u0011QB\u0007\u0003\u0019\u0011\u0013\u0018N^3s%Vtg.\u001a:")
public class WorkerPage
extends WebUIPage {
    private final WorkerWebUI parent;
    private final RpcEndpointRef workerEndpoint;

    private RpcEndpointRef workerEndpoint() {
        return this.workerEndpoint;
    }

    @Override
    public JValue renderJson(HttpServletRequest request) {
        DeployMessages.WorkerStateResponse workerState = (DeployMessages.WorkerStateResponse)this.workerEndpoint().askSync(DeployMessages$RequestWorkerState$.MODULE$, ClassTag$.MODULE$.apply(DeployMessages.WorkerStateResponse.class));
        return JsonProtocol$.MODULE$.writeWorkerState(workerState);
    }

    private String formatWorkerResourcesDetails(DeployMessages.WorkerStateResponse workerState) {
        Map<String, ResourceInformation> totalInfo = workerState.resources();
        Map<String, ResourceInformation> usedInfo = workerState.resourcesUsed();
        Map freeInfo = (Map)totalInfo.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                ResourceInformation rInfo = (ResourceInformation)tuple2._2();
                String[] freeAddresses = usedInfo.contains((Object)rName) ? (String[])ArrayOps$.MODULE$.diff$extension(Predef$.MODULE$.refArrayOps((Object[])rInfo.addresses()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])((ResourceInformation)usedInfo.apply((Object)rName)).addresses())) : rInfo.addresses();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)new ResourceInformation(rName, freeAddresses));
            }
            throw new MatchError((Object)tuple2);
        });
        return StandaloneResourceUtils$.MODULE$.formatResourcesDetails(usedInfo, (Map<String, ResourceInformation>)freeInfo);
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        DeployMessages.WorkerStateResponse workerState = (DeployMessages.WorkerStateResponse)this.workerEndpoint().askSync(DeployMessages$RequestWorkerState$.MODULE$, ClassTag$.MODULE$.apply(DeployMessages.WorkerStateResponse.class));
        .colon.colon executorHeaders = new .colon.colon((Object)"ExecutorID", (List)new .colon.colon((Object)"State", (List)new .colon.colon((Object)"Cores", (List)new .colon.colon((Object)"Memory", (List)new .colon.colon((Object)"Resources", (List)new .colon.colon((Object)"Job Details", (List)new .colon.colon((Object)"Logs", (List)Nil$.MODULE$)))))));
        List<ExecutorRunner> runningExecutors = workerState.executors();
        scala.collection.immutable.Seq<Node> runningExecutorTable = UIUtils$.MODULE$.listingTable((scala.collection.immutable.Seq<String>)executorHeaders, (Function1 & Serializable)executor -> this.executorRow((ExecutorRunner)executor), runningExecutors, UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8(), UIUtils$.MODULE$.listingTable$default$9());
        List<ExecutorRunner> finishedExecutors = workerState.finishedExecutors();
        scala.collection.immutable.Seq<Node> finishedExecutorTable = UIUtils$.MODULE$.listingTable((scala.collection.immutable.Seq<String>)executorHeaders, (Function1 & Serializable)executor -> this.executorRow((ExecutorRunner)executor), finishedExecutors, UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8(), UIUtils$.MODULE$.listingTable$default$9());
        scala.collection.immutable.Seq driverHeaders = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DriverID", "Main Class", "State", "Cores", "Memory", "Resources", "Logs", "Notes"}));
        List runningDrivers = ((List)workerState.drivers().sortBy((Function1 & Serializable)x$1 -> x$1.driverId(), (Ordering)Ordering.String$.MODULE$)).reverse();
        scala.collection.immutable.Seq<Node> runningDriverTable = UIUtils$.MODULE$.listingTable((scala.collection.immutable.Seq<String>)driverHeaders, (Function1 & Serializable)x$2 -> this.driverRow(workerState.workerId(), (DriverRunner)x$2), runningDrivers, UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8(), UIUtils$.MODULE$.listingTable$default$9());
        List finishedDrivers = ((List)workerState.finishedDrivers().sortBy((Function1 & Serializable)x$3 -> x$3.driverId(), (Ordering)Ordering.String$.MODULE$)).reverse();
        scala.collection.immutable.Seq<Node> finishedDriverTable = UIUtils$.MODULE$.listingTable((scala.collection.immutable.Seq<String>)driverHeaders, (Function1 & Serializable)x$4 -> this.driverRow(workerState.workerId(), (DriverRunner)x$4), finishedDrivers, UIUtils$.MODULE$.listingTable$default$4(), UIUtils$.MODULE$.listingTable$default$5(), UIUtils$.MODULE$.listingTable$default$6(), UIUtils$.MODULE$.listingTable$default$7(), UIUtils$.MODULE$.listingTable$default$8(), UIUtils$.MODULE$.listingTable$default$9());
        String workerUrlRef = UIUtils$.MODULE$.makeHref(this.parent.worker().reverseProxy(), workerState.workerId(), this.parent.webUrl());
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)new Comment(" Worker Details "));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf5 = new NodeBuffer();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("ID:"));
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n              "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", workerUrlRef + "/logPage/?self&logType=out", (MetaData)$md4);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)workerState.workerId());
        $buf5.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n              Master URL:"));
        $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text(" "));
        $buf8.$amp$plus((Object)workerState.masterUrl());
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf4.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("Cores:"));
        $buf10.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf10.$amp$plus((Object)new Text(" "));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)workerState.cores()));
        $buf10.$amp$plus((Object)new Text(" ("));
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)workerState.coresUsed()));
        $buf10.$amp$plus((Object)new Text(" Used)"));
        $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf4.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Memory:"));
        $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf12.$amp$plus((Object)new Text(" "));
        $buf12.$amp$plus((Object)Utils$.MODULE$.megabytesToString(workerState.memory()));
        $buf12.$amp$plus((Object)new Text("\n              ("));
        $buf12.$amp$plus((Object)Utils$.MODULE$.megabytesToString(workerState.memoryUsed()));
        $buf12.$amp$plus((Object)new Text(" Used)"));
        $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf4.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf14 = new NodeBuffer();
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("Resources:"));
        $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text("\n              "));
        $buf14.$amp$plus((Object)this.formatWorkerResourcesDetails(workerState));
        $buf4.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf3.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf16 = new NodeBuffer();
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("href", workerState.masterWebUiUrl(), (MetaData)$md5);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("Back to Master"));
        $buf16.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", (Seq)new Text("row"), (MetaData)$md6);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text(" "));
        $buf18.$amp$plus((Object)new Comment(" Executors and Drivers "));
        $buf18.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("col-12"), (MetaData)$md7);
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("\n          "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-runningExecutors',\n              'aggregated-runningExecutors')"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-runningExecutors collapse-table"), (MetaData)$md8);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("\n              "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md9);
        $buf21.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf21.$amp$plus((Object)new Text("\n              "));
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("Running Executors ("));
        $buf22.$amp$plus((Object)BoxesRunTime.boxToInteger((int)runningExecutors.size()));
        $buf22.$amp$plus((Object)new Text(")"));
        $buf21.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf21.$amp$plus((Object)new Text("\n            "));
        $buf20.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf20.$amp$plus((Object)new Text("\n          "));
        $buf19.$amp$plus((Object)new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf19.$amp$plus((Object)new Text("\n          "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-runningExecutors collapsible-table"), (MetaData)$md10);
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("\n            "));
        $buf23.$amp$plus(runningExecutorTable);
        $buf23.$amp$plus((Object)new Text("\n          "));
        $buf19.$amp$plus((Object)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
        $buf19.$amp$plus((Object)new Text("\n          "));
        if (runningDrivers.nonEmpty()) {
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-runningDrivers',\n                  'aggregated-runningDrivers')"), (MetaData)$md11);
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-runningDrivers collapse-table"), (MetaData)$md11);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n                  "));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md12);
            $buf25.$amp$plus((Object)new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf25.$amp$plus((Object)new Text("\n                  "));
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("Running Drivers ("));
            $buf26.$amp$plus((Object)BoxesRunTime.boxToInteger((int)runningDrivers.size()));
            $buf26.$amp$plus((Object)new Text(")"));
            $buf25.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26)));
            $buf25.$amp$plus((Object)new Text("\n                "));
            $buf24.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
            $buf24.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "span", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-runningDrivers collapsible-table"), (MetaData)$md13);
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n                "));
            $buf27.$amp$plus(runningDriverTable);
            $buf27.$amp$plus((Object)new Text("\n              "));
            boxedUnit3 = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $buf19.$amp$plus((Object)boxedUnit3);
        $buf19.$amp$plus((Object)new Text("\n          "));
        if (finishedExecutors.nonEmpty()) {
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-finishedExecutors',\n                  'aggregated-finishedExecutors')"), (MetaData)$md14);
            $md14 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-finishedExecutors collapse-table"), (MetaData)$md14);
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n                  "));
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md15);
            $buf29.$amp$plus((Object)new Elem(null, "span", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf29.$amp$plus((Object)new Text("\n                  "));
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("Finished Executors ("));
            $buf30.$amp$plus((Object)BoxesRunTime.boxToInteger((int)finishedExecutors.size()));
            $buf30.$amp$plus((Object)new Text(")"));
            $buf29.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
            $buf29.$amp$plus((Object)new Text("\n                "));
            $buf28.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)));
            $buf28.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "span", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-finishedExecutors collapsible-table"), (MetaData)$md16);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)new Text("\n                "));
            $buf31.$amp$plus(finishedExecutorTable);
            $buf31.$amp$plus((Object)new Text("\n              "));
            boxedUnit2 = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31)));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf19.$amp$plus((Object)boxedUnit2);
        $buf19.$amp$plus((Object)new Text("\n          "));
        if (finishedDrivers.nonEmpty()) {
            Null$ $md17 = Null$.MODULE$;
            $md17 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-finishedDrivers',\n                  'aggregated-finishedDrivers')"), (MetaData)$md17);
            $md17 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-finishedDrivers collapse-table"), (MetaData)$md17);
            NodeBuffer $buf32 = new NodeBuffer();
            $buf32.$amp$plus((Object)new Text("\n                "));
            NodeBuffer $buf33 = new NodeBuffer();
            $buf33.$amp$plus((Object)new Text("\n                  "));
            Null$ $md18 = Null$.MODULE$;
            $md18 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md18);
            $buf33.$amp$plus((Object)new Elem(null, "span", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf33.$amp$plus((Object)new Text("\n                  "));
            NodeBuffer $buf34 = new NodeBuffer();
            $buf34.$amp$plus((Object)new Text("Finished Drivers ("));
            $buf34.$amp$plus((Object)BoxesRunTime.boxToInteger((int)finishedDrivers.size()));
            $buf34.$amp$plus((Object)new Text(")"));
            $buf33.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34)));
            $buf33.$amp$plus((Object)new Text("\n                "));
            $buf32.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
            $buf32.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "span", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32));
            Null$ $md19 = Null$.MODULE$;
            $md19 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-finishedDrivers collapsible-table"), (MetaData)$md19);
            NodeBuffer $buf35 = new NodeBuffer();
            $buf35.$amp$plus((Object)new Text("\n                "));
            $buf35.$amp$plus(finishedDriverTable);
            $buf35.$amp$plus((Object)new Text("\n              "));
            boxedUnit = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf19.$amp$plus((Object)boxedUnit);
        $buf19.$amp$plus((Object)new Text("\n        "));
        $buf18.$amp$plus((Object)new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf18.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        NodeBuffer content = $buf;
        return UIUtils$.MODULE$.basicSparkPage(request, (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> NodeSeq$.MODULE$.seqToNodeSeq((Seq)content), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Spark Worker at %s:%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{workerState.host(), BoxesRunTime.boxToInteger((int)workerState.port())})), UIUtils$.MODULE$.basicSparkPage$default$4());
    }

    public scala.collection.immutable.Seq<Node> executorRow(ExecutorRunner executor) {
        String string;
        String workerUrlRef = UIUtils$.MODULE$.makeHref(this.parent.worker().reverseProxy(), executor.workerId(), this.parent.webUrl());
        String appUrlRef = UIUtils$.MODULE$.makeHref(this.parent.worker().reverseProxy(), executor.appId(), executor.appDesc().appUiUrl());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)executor.execId()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)executor.state());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)executor.cores()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(executor.memory()), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)Utils$.MODULE$.megabytesToString(executor.memory()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)StandaloneResourceUtils$.MODULE$.formatResourcesAddresses(executor.resources()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md2);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("ID:"));
        $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text(" "));
        $buf9.$amp$plus((Object)executor.appId());
        $buf8.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf11 = new NodeBuffer();
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("Name:"));
        $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n          "));
        Enumeration.Value value = executor.state();
        Enumeration.Value value2 = ExecutorState$.MODULE$.RUNNING();
        if (!(value != null ? !value.equals(value2) : value2 != null) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(executor.appDesc().appUiUrl()))) {
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("href", appUrlRef, (MetaData)$md3);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text(" "));
            $buf13.$amp$plus((Object)executor.appDesc().name());
            Elem elem = new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13));
            string = elem;
        } else {
            string = executor.appDesc().name();
        }
        $buf11.$amp$plus((Object)string);
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf8.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf14 = new NodeBuffer();
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("User:"));
        $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf14.$amp$plus((Object)new Text(" "));
        $buf14.$amp$plus((Object)executor.appDesc().user());
        $buf8.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", workerUrlRef + "/logPage/?appId=" + executor.appId() + "&executorId=" + executor.execId() + "&logType=stdout", (MetaData)$md4);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("stdout"));
        $buf16.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf16.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("href", workerUrlRef + "/logPage/?appId=" + executor.appId() + "&executorId=" + executor.execId() + "&logType=stderr", (MetaData)$md5);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("stderr"));
        $buf16.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf16.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public scala.collection.immutable.Seq<Node> driverRow(String workerId, DriverRunner driver) {
        String workerUrlRef = UIUtils$.MODULE$.makeHref(this.parent.worker().reverseProxy(), workerId, this.parent.webUrl());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)driver.driverId());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus(driver.driverDesc().command().arguments().apply(2));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus(driver.finalState().getOrElse((Function0 & Serializable)() -> DriverState$.MODULE$.RUNNING()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("sorttable_customkey", Integer.toString(driver.driverDesc().cores()), (MetaData)$md);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)Integer.toString(driver.driverDesc().cores()));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("sorttable_customkey", Integer.toString(driver.driverDesc().mem()), (MetaData)$md2);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)Utils$.MODULE$.megabytesToString(driver.driverDesc().mem()));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)StandaloneResourceUtils$.MODULE$.formatResourcesAddresses(driver.resources()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("href", workerUrlRef + "/logPage/?driverId=" + driver.driverId() + "&logType=stdout", (MetaData)$md3);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("stdout"));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("href", workerUrlRef + "/logPage/?driverId=" + driver.driverId() + "&logType=stderr", (MetaData)$md4);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("stderr"));
        $buf8.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf11.$amp$plus(driver.finalException().getOrElse((Function0 & Serializable)() -> ""));
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public WorkerPage(WorkerWebUI parent) {
        this.parent = parent;
        super("");
        this.workerEndpoint = parent.worker().self();
    }
}

