/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumn;
import org.apache.spark.sql.execution.datasources.parquet.ParquetColumnVector;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015v!\u0002\u000e\u001c\u0011\u0003Qc!\u0002\u0017\u001c\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)d\u0001\u0002\u001c\u0002\u0001]B\u0001\u0002O\u0002\u0003\u0002\u0003\u0006I!\u000f\u0005\u0006i\r!\t\u0001\u0010\u0005\n\u0001\u000e\u0001\r\u00111A\u0005\u0002\u0005C\u0011\"U\u0002A\u0002\u0003\u0007I\u0011\u0001*\t\u0013a\u001b\u0001\u0019!A!B\u0013\u0011\u0005\"B-\u0004\t\u0003Q\u0006\"\u00024\u0004\t\u00039\u0007\"\u00024\u0004\t\u0003\u0011\b\"\u0002?\u0002\t\u0003ihABA\u0007\u0003\u0011\ty\u0001\u0003\u0006\u0002>5\u0011\t\u0011)A\u0005\u0003\u007fA\u0001\u0002O\u0007\u0003\u0002\u0003\u0006I!\u000f\u0005\u0007i5!\t!!\u0013\t\u000f\u0005ES\u0002\"\u0011\u0002T!9\u0011\u0011N\u0007\u0005B\u0005-\u0004bBA:\u001b\u0011\u0005\u0013Q\u000f\u0005\b\u0003ojA\u0011IA=\u0011\u001d\tY(\u0004C!\u0003{Bq!!\"\u000e\t\u0003\n9\tC\u0004\u0002\n\u0006!\t!a#\t\u000f\u0005M\u0015\u0001\"\u0001\u0002\u0016\"9\u0011\u0011T\u0001\u0005\u0002\u0005m\u0015a\u0005)beF,X\r\u001e*po&sG-\u001a=Vi&d'B\u0001\u000f\u001e\u0003\u001d\u0001\u0018M]9vKRT!AH\u0010\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003A\u0005\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005-\nQ\"A\u000e\u0003'A\u000b'/];fiJ{w/\u00138eKb,F/\u001b7\u0014\u0005\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002U\t\t\"k\\<J]\u0012,\u0007pR3oKJ\fGo\u001c:\u0014\u0005\rq\u0013!\u0005:po&sG-\u001a=D_2,XN\\%eqB\u0011qFO\u0005\u0003wA\u00121!\u00138u)\tit\b\u0005\u0002?\u00075\t\u0011\u0001C\u00039\u000b\u0001\u0007\u0011(\u0001\ts_^Le\u000eZ3y\u0013R,'/\u0019;peV\t!\tE\u0002D\u0017:s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001dK\u0013A\u0002\u001fs_>$h(C\u00012\u0013\tQ\u0005'A\u0004qC\u000e\\\u0017mZ3\n\u00051k%\u0001C%uKJ\fGo\u001c:\u000b\u0005)\u0003\u0004CA\u0018P\u0013\t\u0001\u0006G\u0001\u0003M_:<\u0017\u0001\u0006:po&sG-\u001a=Ji\u0016\u0014\u0018\r^8s?\u0012*\u0017\u000f\u0006\u0002T-B\u0011q\u0006V\u0005\u0003+B\u0012A!\u00168ji\"9qkBA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005\t\"o\\<J]\u0012,\u00070\u0013;fe\u0006$xN\u001d\u0011\u0002+%t\u0017\u000e\u001e$s_6\u0004\u0016mZ3SK\u0006$7\u000b^8sKR\u00111k\u0017\u0005\u00069&\u0001\r!X\u0001\u0006a\u0006<Wm\u001d\t\u0003=\u0012l\u0011a\u0018\u0006\u0003A\u0006\fA\u0001]1hK*\u0011!mY\u0001\u0007G>dW/\u001c8\u000b\u0005q)\u0013BA3`\u00055\u0001\u0016mZ3SK\u0006$7\u000b^8sK\u0006\u0001\u0002o\u001c9vY\u0006$XMU8x\u0013:$W\r\u001f\u000b\u0004'\"\u0004\b\"B5\u000b\u0001\u0004Q\u0017!D2pYVlgNV3di>\u00148\u000fE\u00020W6L!\u0001\u001c\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-r\u0017BA8\u001c\u0005M\u0001\u0016M]9vKR\u001cu\u000e\\;n]Z+7\r^8s\u0011\u0015\t(\u00021\u0001:\u0003\u001dqW/\u001c*poN$2aU:|\u0011\u0015!8\u00021\u0001v\u00031\u0019w\u000e\\;n]Z+7\r^8s!\t1\u00180D\u0001x\u0015\tAx$\u0001\u0006wK\u000e$xN]5{K\u0012L!A_<\u0003)]\u0013\u0018\u000e^1cY\u0016\u001cu\u000e\\;n]Z+7\r^8s\u0011\u0015\t8\u00021\u0001:\u0003]\u0019'/Z1uK\u001e+g.\u001a:bi>\u0014\u0018J\u001a(fK\u0012,G\r\u0006\u0002>}\"1q\u0010\u0004a\u0001\u0003\u0003\t1b\u001d9be.\u001c6\r[3nCB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0005\nQ\u0001^=qKNLA!a\u0003\u0002\u0006\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u00035I+7m\u001c:e%\u0016\fG-\u001a:XSRD'k\\<J]\u0012,\u00070Z:\u0014\u00075\t\t\u0002\u0005\u0005\u0002\u0014\u0005u\u0011\u0011EA\u0019\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C7baJ,G-^2f\u0015\r\tY\"J\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005}\u0011Q\u0003\u0002\r%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002&\t!ak\\5e!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001cC\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002<\u0005U\"aC%oi\u0016\u0014h.\u00197S_^\fa\u0001]1sK:$\bCBA!\u0003\u000b\n\t$\u0004\u0002\u0002D)\u0019\u00111D2\n\t\u0005\u001d\u00131\t\u0002\u0014!\u0006\u0014\u0018/^3u%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u000b\u0007\u0003\u0017\ni%a\u0014\u0011\u0005yj\u0001bBA\u001f!\u0001\u0007\u0011q\b\u0005\u0006qA\u0001\r!O\u0001\u000bS:LG/[1mSj,G#B*\u0002V\u0005}\u0003bBA,#\u0001\u0007\u0011\u0011L\u0001\u000bS:\u0004X\u000f^*qY&$\b\u0003BA\n\u00037JA!!\u0018\u0002\u0016\tQ\u0011J\u001c9viN\u0003H.\u001b;\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002d\u0005\u0011B/Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u!\u0011\t\u0019\"!\u001a\n\t\u0005\u001d\u0014Q\u0003\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH/\u0001\u0007oKb$8*Z=WC2,X\r\u0006\u0002\u0002nA\u0019q&a\u001c\n\u0007\u0005E\u0004GA\u0004C_>dW-\u00198\u0002\u001b\u001d,GoQ;se\u0016tGoS3z)\t\t\t#A\bhKR\u001cUO\u001d:f]R4\u0016\r\\;f)\t\t\t$A\u0006hKR\u0004&o\\4sKN\u001cHCAA@!\ry\u0013\u0011Q\u0005\u0004\u0003\u0007\u0003$!\u0002$m_\u0006$\u0018!B2m_N,G#A*\u0002C\u0005$GMU8x\u0013:$W\r\u001f+p%\u0016\u001cwN\u001d3SK\u0006$WM]%g\u001d\u0016,G-\u001a3\u0015\r\u0005E\u0011QRAI\u0011\u001d\tyi\u0006a\u0001\u0003\u007f\taA]3bI\u0016\u0014\bBB@\u0018\u0001\u0004\t\t!A\u0010gS:$'k\\<J]\u0012,\u0007pQ8mk6t\u0017J\u001c3fq&s7k\u00195f[\u0006$2!OAL\u0011\u0019y\b\u00041\u0001\u0002\u0002\u0005\u0001\u0012n\u001d*po&sG-\u001a=D_2,XN\u001c\u000b\u0005\u0003[\ni\n\u0003\u0004c3\u0001\u0007\u0011q\u0014\t\u0004W\u0005\u0005\u0016bAAR7\ti\u0001+\u0019:rk\u0016$8i\u001c7v[:\u0004")
public final class ParquetRowIndexUtil {
    public static boolean isRowIndexColumn(ParquetColumn parquetColumn) {
        return ParquetRowIndexUtil$.MODULE$.isRowIndexColumn(parquetColumn);
    }

    public static int findRowIndexColumnIndexInSchema(StructType structType) {
        return ParquetRowIndexUtil$.MODULE$.findRowIndexColumnIndexInSchema(structType);
    }

    public static RecordReader<Void, InternalRow> addRowIndexToRecordReaderIfNeeded(ParquetRecordReader<InternalRow> parquetRecordReader, StructType structType) {
        return ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(parquetRecordReader, structType);
    }

    public static RowIndexGenerator createGeneratorIfNeeded(StructType structType) {
        return ParquetRowIndexUtil$.MODULE$.createGeneratorIfNeeded(structType);
    }

    private static class RecordReaderWithRowIndexes
    extends RecordReader<Void, InternalRow> {
        private final ParquetRecordReader<InternalRow> parent;
        private final int rowIndexColumnIdx;

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            this.parent.initialize(inputSplit, taskAttemptContext);
        }

        public boolean nextKeyValue() {
            return this.parent.nextKeyValue();
        }

        public Void getCurrentKey() {
            return this.parent.getCurrentKey();
        }

        public InternalRow getCurrentValue() {
            InternalRow row = (InternalRow)this.parent.getCurrentValue();
            row.setLong(this.rowIndexColumnIdx, this.parent.getCurrentRowIndex());
            return row;
        }

        public float getProgress() {
            return this.parent.getProgress();
        }

        public void close() {
            this.parent.close();
        }

        public RecordReaderWithRowIndexes(ParquetRecordReader<InternalRow> parent, int rowIndexColumnIdx) {
            this.parent = parent;
            this.rowIndexColumnIdx = rowIndexColumnIdx;
        }
    }

    public static class RowIndexGenerator {
        private final int rowIndexColumnIdx;
        private Iterator<Object> rowIndexIterator;

        public Iterator<Object> rowIndexIterator() {
            return this.rowIndexIterator;
        }

        public void rowIndexIterator_$eq(Iterator<Object> x$1) {
            this.rowIndexIterator = x$1;
        }

        public void initFromPageReadStore(PageReadStore pages) {
            if (!pages.getRowIndexOffset().isPresent()) {
                throw new IOException("PageReadStore returned no row index offset.");
            }
            long startingRowIdx = Predef$.MODULE$.Long2long((Long)pages.getRowIndexOffset().get());
            if (pages.getRowIndexes().isPresent()) {
                this.rowIndexIterator_$eq((Iterator<Object>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)pages.getRowIndexes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)idx -> BoxesRunTime.boxToLong((long)RowIndexGenerator.$anonfun$initFromPageReadStore$1(startingRowIdx, idx))));
                return;
            }
            long numRowsInRowGroup = pages.getRowCount();
            this.rowIndexIterator_$eq((Iterator<Object>)new RichLong(Predef$.MODULE$.longWrapper(startingRowIdx)).until((Object)BoxesRunTime.boxToLong((long)(startingRowIdx + numRowsInRowGroup))).iterator());
        }

        public void populateRowIndex(ParquetColumnVector[] columnVectors, int numRows) {
            this.populateRowIndex(columnVectors[this.rowIndexColumnIdx].getValueVector(), numRows);
        }

        public void populateRowIndex(WritableColumnVector columnVector, int numRows) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> columnVector.putLong(i, BoxesRunTime.unboxToLong((Object)this.rowIndexIterator().next())));
        }

        public static final /* synthetic */ long $anonfun$initFromPageReadStore$1(long startingRowIdx$1, Long idx) {
            return Predef$.MODULE$.Long2long(idx) + startingRowIdx$1;
        }

        public RowIndexGenerator(int rowIndexColumnIdx) {
            this.rowIndexColumnIdx = rowIndexColumnIdx;
        }
    }
}

