/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.sql.types.StructType;

@Experimental
public interface SupportsPartitionManagement
extends Table {
    public StructType partitionSchema();

    public void createPartition(InternalRow var1, Map<String, String> var2) throws PartitionsAlreadyExistException, UnsupportedOperationException;

    public boolean dropPartition(InternalRow var1);

    default public boolean purgePartition(InternalRow ident) throws NoSuchPartitionException, UnsupportedOperationException {
        throw QueryExecutionErrors.unsupportedPurgePartitionError();
    }

    default public boolean partitionExists(InternalRow ident) {
        String[] partitionNames = this.partitionSchema().names();
        if (ident.numFields() == partitionNames.length) {
            return this.listPartitionIdentifiers(partitionNames, ident).length > 0;
        }
        throw new IllegalArgumentException("The number of fields (" + ident.numFields() + ") in the partition identifier is not equal to the partition schema length (" + partitionNames.length + "). The identifier might not refer to one partition.");
    }

    public void replacePartitionMetadata(InternalRow var1, Map<String, String> var2) throws NoSuchPartitionException, UnsupportedOperationException;

    public Map<String, String> loadPartitionMetadata(InternalRow var1) throws UnsupportedOperationException;

    public InternalRow[] listPartitionIdentifiers(String[] var1, InternalRow var2);

    default public boolean renamePartition(InternalRow from, InternalRow to) throws UnsupportedOperationException, PartitionsAlreadyExistException, NoSuchPartitionException {
        throw new UnsupportedOperationException("Partition renaming is not supported");
    }

    default public boolean truncatePartition(InternalRow ident) throws NoSuchPartitionException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Partition truncate is not supported");
    }
}

