/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.lang.reflect.Constructor;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManagerConfig
extends BeanConfig {
    private static final Logger log = LoggerFactory.getLogger(UserManagerConfig.class);
    private Constructor<?> constr;

    public UserManagerConfig(BeanConfig config) {
        super(config);
        this.setValidate(false);
    }

    public UserManager getUserManager(Class<? extends UserManager> assignablefrom, Class<?>[] parameterTypes, Object ... initArgs) throws ConfigurationException {
        if (this.constr == null) {
            String msg = "Invalid UserManager implementation '" + this.getClassName() + "'.";
            try {
                Class<?> umgrCl = Class.forName(this.getClassName(), true, this.getClassLoader());
                if (!assignablefrom.isAssignableFrom(umgrCl)) {
                    throw new ConfigurationException("Configured UserManager '" + this.getClassName() + "' is not assignable from " + assignablefrom);
                }
                this.constr = umgrCl.getConstructor(parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(msg, e);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(msg, e);
            }
        }
        try {
            return (UserManager)this.constr.newInstance(initArgs);
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid UserManager implementation '" + this.getClassName() + "'.", e);
        }
    }
}

