/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.email.impl;

import java.io.IOException;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.testing.email.impl.SmtpServerWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"osgi.http.whiteboard.servlet.pattern=/system/sling/testing/email", "osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=org.osgi.service.http)"})
public class EMailServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private SmtpServerWrapper wiser;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        resp.setContentType("application/json");
        JSONWriter w = new JSONWriter(resp.getWriter());
        switch (action = req.getPathInfo() == null || req.getPathInfo().isEmpty() ? "messages" : req.getPathInfo().substring(1)) {
            case "messages": {
                w.object();
                w.key("messages");
                w.array();
                for (MimeMessage msg : this.wiser.getMessages()) {
                    w.object();
                    try {
                        Enumeration headers = msg.getAllHeaders();
                        while (headers.hasMoreElements()) {
                            Header header = (Header)headers.nextElement();
                            w.key(header.getName()).value(header.getValue());
                        }
                        w.key("-Content-").value(msg.getContent());
                    }
                    catch (MessagingException e) {
                        throw new ServletException("Failed retrieving message data", (Throwable)e);
                    }
                    w.endObject();
                }
                w.endArray();
                w.endObject();
                break;
            }
            case "config": {
                w.object();
                w.key("bindPort").value(this.wiser.getEffectiveBindPort());
                w.endObject();
                break;
            }
            default: {
                resp.setStatus(400);
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.wiser.clearMessages();
        resp.setStatus(204);
    }
}

