/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.api.internal;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Option<T> {
    private final T element;
    private final int argumentId;

    private Option(T element, int argumentId) {
        this.element = element;
        this.argumentId = argumentId;
    }

    public static <T> Option<T> of(T element, int argumentId) {
        return new Option<T>(element, argumentId);
    }

    public static <T> Option<T> empty(int argumentId) {
        return new Option<Object>(null, argumentId);
    }

    public int getArgumentId() {
        return this.argumentId;
    }

    public T getElement() {
        return this.element;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Option[-]";
        }
        return String.format("Option[%s]", this.element.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Option rhs = (Option)obj;
        return new EqualsBuilder().append(this.element, rhs.element).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.element).toHashCode();
    }
}

