/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.sling.performance.PerformanceRecord;
import org.apache.sling.performance.PerformanceRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportLogger {
    private static boolean reportFolderLogged = false;
    private static final Logger logger = LoggerFactory.getLogger(ReportLogger.class);
    public static final String REPORTS_DIR = "performance-reports";
    private static final MultiKeyMap reportLoggers = new MultiKeyMap();
    private final String testSuiteName;
    private final String testCaseName;
    private final String className;
    private final String referenceMethod;
    private final Map<String, PerformanceRecord> records = new LinkedHashMap<String, PerformanceRecord>();

    private ReportLogger() {
        this.testSuiteName = null;
        this.testCaseName = null;
        this.className = null;
        this.referenceMethod = null;
    }

    private ReportLogger(String testSuiteName, String testCaseName, String className, String referenceMethod) {
        this.testSuiteName = testSuiteName;
        this.testCaseName = testCaseName;
        this.className = className;
        this.referenceMethod = referenceMethod;
    }

    public static ReportLogger getOrCreate(String testSuiteName, String testCaseName, String className, String referenceMethod) {
        Object reportLogger = reportLoggers.get((Object)testSuiteName, (Object)testCaseName, (Object)className, (Object)referenceMethod);
        if (reportLogger == null) {
            reportLogger = new ReportLogger(testSuiteName, testCaseName, className, referenceMethod);
            reportLoggers.put((Object)testSuiteName, (Object)testCaseName, (Object)className, (Object)referenceMethod, reportLogger);
        }
        return (ReportLogger)reportLogger;
    }

    public static void writeReport(String testSuiteName, String testCaseName, String className, String methodName, DescriptiveStatistics statistics, ReportType reportType, PerformanceRunner.ReportLevel reportLevel) throws Exception {
        switch (reportType) {
            case TXT: {
                ReportLogger.writeReportTxt(testSuiteName, testCaseName, className, methodName, statistics, reportLevel);
                break;
            }
            default: {
                throw new Exception("The specified reporting format is not yet supported");
            }
        }
    }

    public static void writeReportTxt(String testSuiteName, String testCaseName, String className, String methodName, DescriptiveStatistics statistics, PerformanceRunner.ReportLevel reportLevel) throws Exception {
        ReportLogger.writeReportTxt(testSuiteName, testCaseName, className, methodName, statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax(), reportLevel);
    }

    public static void writeReportTxt(String testSuiteName, String testCaseName, String className, String methodName, double min, double percentile10, double percentile50, double percentile90, double max, PerformanceRunner.ReportLevel reportLevel) throws Exception {
        ReportLogger.writeReportTxt(testSuiteName, testCaseName, className, methodName, min, percentile10, percentile50, percentile90, max, reportLevel, false);
    }

    public static void writeReportTxt(String testSuiteName, String testCaseName, String className, String methodName, double min, double percentile10, double percentile50, double percentile90, double max, PerformanceRunner.ReportLevel reportLevel, boolean showDecimals) throws Exception {
        File reportDir = new File("target/performance-reports");
        if (!reportDir.exists() && !reportDir.mkdir()) {
            throw new IOException("Unable to create performance-reports directory");
        }
        if (testSuiteName.equals("TESTCASEONLY") && System.getProperty("testsuitename") != null) {
            testSuiteName = System.getProperty("testsuitename");
        }
        if (reportLevel.equals((Object)PerformanceRunner.ReportLevel.ClassLevel)) {
            String resultFileName = className;
            ReportLogger.writeReportClassLevel(resultFileName, testSuiteName, min, percentile10, percentile50, percentile90, max);
        } else if (reportLevel.equals((Object)PerformanceRunner.ReportLevel.MethodLevel)) {
            String resultFileName = className + "." + methodName;
            ReportLogger.writeReportMethodLevel(resultFileName, testSuiteName, testCaseName, className, methodName, min, percentile10, percentile50, percentile90, max, showDecimals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeReportClassLevel(String resultFileName, String testSuiteName, double min, double percentile10, double percentile50, double percentile90, double max) throws IOException {
        File report = ReportLogger.getReportFile(resultFileName, ".txt");
        boolean needsPrefix = !report.exists();
        PrintWriter writer = new PrintWriter((Writer)new FileWriterWithEncoding(report, "UTF-8", true));
        try {
            if (needsPrefix) {
                writer.format("# %-50.50s     min     10%%     50%%     90%%     max%n", resultFileName);
            }
            writer.format("%-52.52s  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f%n", testSuiteName, min, percentile10, percentile50, percentile90, max);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeReportMethodLevel(String resultFileName, String testSuiteName, String testCaseName, String className, String methodName, double min, double percentile10, double percentile50, double percentile90, double max, boolean showDecimals) throws IOException {
        File report = ReportLogger.getReportFile(resultFileName, ".txt");
        boolean needsPrefix = !report.exists();
        PrintWriter writer = new PrintWriter((Writer)new FileWriterWithEncoding(report, "UTF-8", true));
        try {
            if (needsPrefix) {
                writer.format("%-40.40s|%-120.120s|%-80.80s|%-40.40s|      DateTime      |  min  |   10%%   |   50%%   |   90%%   |   max%n", "Test Suite", "Test Case", "Test Class", "Test Method");
            }
            writer.format(showDecimals ? "%-40.40s|%-120.120s|%-80.80s|%-40.40s|%-20.20s|%7.2f|%9.2f|%9.2f|%9.2f|%9.2f%n" : "%-40.40s|%-120.120s|%-80.80s|%-40.40s|%-20.20s|%7.0f|%9.0f|%9.0f|%9.0f|%9.0f%n", testSuiteName, testCaseName.length() < 120 ? testCaseName : testCaseName.substring(0, 115) + "[...]", className, methodName, ReportLogger.getDate(), min, percentile10, percentile50, percentile90, max);
        }
        finally {
            writer.close();
        }
    }

    private static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private static File getReportFile(String resultFileName, String extension) {
        String folder = "target/performance-reports";
        String filename = resultFileName + extension;
        if (!reportFolderLogged) {
            logger.info("Writing performance test results under {}", (Object)"target/performance-reports");
            reportFolderLogged = true;
        }
        return new File("target/performance-reports", filename);
    }

    public static void writeAllResults() throws Exception {
        for (Object reportLogger : reportLoggers.values()) {
            ((ReportLogger)reportLogger).writeResults();
        }
    }

    public static List<Failure> checkAllThresholds() throws ClassNotFoundException {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (Object reportLogger : reportLoggers.values()) {
            failures.addAll(((ReportLogger)reportLogger).checkThresholds());
        }
        return failures;
    }

    public void recordStatistics(String methodName, DescriptiveStatistics statistics, double threshold) {
        this.records.put(methodName, new PerformanceRecord(statistics, threshold));
    }

    public void writeResults() throws Exception {
        PerformanceRecord referenceRecord = this.records.get(this.referenceMethod);
        for (String methodName : this.records.keySet()) {
            DescriptiveStatistics statistics = this.records.get(methodName).getStatistics();
            double min = statistics.getMin();
            double percentile10 = statistics.getPercentile(10.0);
            double percentile50 = statistics.getPercentile(50.0);
            double percentile90 = statistics.getPercentile(90.0);
            double max = statistics.getMax();
            boolean showDecimals = false;
            if (referenceRecord != null && !this.referenceMethod.equals(methodName)) {
                DescriptiveStatistics referenceStatistics = referenceRecord.getStatistics();
                double ref = referenceStatistics.getMin();
                min = ref == 0.0 ? Double.POSITIVE_INFINITY : min / ref;
                ref = referenceStatistics.getPercentile(10.0);
                percentile10 = ref == 0.0 ? Double.POSITIVE_INFINITY : percentile10 / ref;
                ref = referenceStatistics.getPercentile(50.0);
                percentile50 = ref == 0.0 ? Double.POSITIVE_INFINITY : percentile50 / ref;
                ref = referenceStatistics.getPercentile(90.0);
                percentile90 = ref == 0.0 ? Double.POSITIVE_INFINITY : percentile90 / ref;
                ref = referenceStatistics.getMax();
                max = ref == 0.0 ? Double.POSITIVE_INFINITY : max / referenceStatistics.getMax();
                showDecimals = true;
            }
            ReportLogger.writeReportTxt(this.testSuiteName, this.testCaseName, Class.forName(this.className).getSimpleName(), methodName, min, percentile10, percentile50, percentile90, max, PerformanceRunner.ReportLevel.MethodLevel, showDecimals);
        }
    }

    public List<Failure> checkThresholds() throws ClassNotFoundException {
        PerformanceRecord referenceRecord = this.records.get(this.referenceMethod);
        if (referenceRecord == null) {
            return Collections.EMPTY_LIST;
        }
        DescriptiveStatistics referenceStatistics = referenceRecord.getStatistics();
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (String methodName : this.records.keySet()) {
            PerformanceRecord performanceRecord = this.records.get(methodName);
            String result = performanceRecord.checkThreshold(referenceStatistics);
            if (result == null) continue;
            failures.add(new Failure(Description.createTestDescription(Class.forName(this.className), (String)methodName), (Throwable)new Exception(result)));
        }
        return failures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        TXT;

    }
}

