/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.login.impl;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.auth.xing.login.XingLoginUserManager;
import org.apache.sling.auth.xing.login.XingLoginUtil;
import org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING Login \u201cLogin Module Plugin\u201d", description="Login Module Plugin for Sling Authentication XING Login", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Login Module Plugin for Sling Authentication XING Login"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false)})
public class XingLoginLoginModulePlugin
implements LoginModulePlugin {
    @Reference
    private XingLoginUserManager xingLoginUserManager;
    private final Logger logger = LoggerFactory.getLogger(XingLoginLoginModulePlugin.class);

    public boolean canHandle(Credentials credentials) {
        this.logger.debug("canHandle({})", (Object)credentials);
        String hash = XingLoginUtil.getHash(credentials);
        String user = XingLoginUtil.getUser(credentials);
        this.logger.debug("hash: {}, user: {}", (Object)hash, (Object)user);
        return hash != null && user != null;
    }

    public void doInit(CallbackHandler callbackHandler, Session session, Map map) throws LoginException {
        this.logger.debug("doInit({}, {}, {})", new Object[]{callbackHandler, session, map});
    }

    public Principal getPrincipal(Credentials credentials) {
        this.logger.debug("getPrincipal({})", (Object)credentials);
        try {
            User user = this.xingLoginUserManager.getUser(credentials);
            if (user == null && this.xingLoginUserManager.autoCreate()) {
                user = this.xingLoginUserManager.createUser(credentials);
            }
            if (user != null) {
                return user.getPrincipal();
            }
        }
        catch (RepositoryException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void addPrincipals(Set set) {
        this.logger.debug("addPrincipals({})", (Object)set);
    }

    public AuthenticationPlugin getAuthentication(Principal principal, Credentials credentials) throws RepositoryException {
        this.logger.debug("getAuthentication({}, {})", (Object)principal, (Object)credentials);
        return new XingLoginAuthenticationPlugin(this.xingLoginUserManager);
    }

    public int impersonate(Principal principal, Credentials credentials) throws RepositoryException, FailedLoginException {
        this.logger.debug("impersonate({}, {})", (Object)principal, (Object)credentials);
        return 0;
    }

    protected void bindXingLoginUserManager(XingLoginUserManager xingLoginUserManager) {
        this.xingLoginUserManager = xingLoginUserManager;
    }

    protected void unbindXingLoginUserManager(XingLoginUserManager xingLoginUserManager) {
        if (this.xingLoginUserManager == xingLoginUserManager) {
            this.xingLoginUserManager = null;
        }
    }
}

