/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class HttpClientSendAsyncInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        HttpRequest request = (HttpRequest)allArguments[0];
        URI uri = request.uri();
        ContextCarrier contextCarrier = new ContextCarrier();
        AbstractSpan span = ContextManager.createExitSpan((String)this.buildOperationName(request.method(), uri), (ContextCarrier)contextCarrier, (String)this.getPeer(uri));
        if (request instanceof EnhancedInstance) {
            ((EnhancedInstance)request).setSkyWalkingDynamicField((Object)contextCarrier);
        }
        span.setComponent((Component)ComponentsDefine.JDK_HTTP);
        Tags.HTTP.METHOD.set(span, request.method());
        Tags.URL.set(span, String.valueOf(uri));
        SpanLayer.asHttp((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ContextManager.isActive()) {
            AbstractSpan span = ContextManager.activeSpan();
            span.prepareForAsync();
            if (ret != null) {
                CompletableFuture future = (CompletableFuture)ret;
                ret = future.whenComplete((response, throwable) -> {
                    try {
                        if (throwable != null) {
                            span.errorOccurred();
                            span.log(throwable);
                            return;
                        }
                        if (response instanceof HttpResponse) {
                            HttpResponse httpResponse = (HttpResponse)response;
                            int statusCode = httpResponse.statusCode();
                            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
                            if (statusCode >= 400) {
                                span.errorOccurred();
                            }
                        }
                    }
                    finally {
                        span.asyncFinish();
                    }
                });
            } else {
                HashMap<String, String> eventMap = new HashMap<String, String>();
                eventMap.put("error", "No response");
                span.log(System.currentTimeMillis(), eventMap);
                span.errorOccurred();
            }
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }

    private String buildOperationName(String method, URI uri) {
        String path = uri.getPath();
        if (path == null || path.isEmpty()) {
            path = "/";
        }
        return method + ":" + path;
    }

    private String getPeer(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = "https".equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
        }
        return host + ":" + port;
    }
}

