/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.ObjectStreamException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EnumMap;
import org.apache.sis.math.NumberType;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.internal.shared.LocalizedParseException;

final class DefaultFormat
extends Format {
    private static final long serialVersionUID = -2309270763519060316L;
    private static final EnumMap<NumberType, Format> INSTANCES = new EnumMap(NumberType.class);
    private final Class<?> type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Format getInstance(Class<?> type) {
        EnumMap<NumberType, Format> enumMap = INSTANCES;
        synchronized (enumMap) {
            return INSTANCES.computeIfAbsent(NumberType.forNumberClass(type), DefaultFormat::new);
        }
    }

    private DefaultFormat(NumberType type) {
        this.type = type.classOfValues(false);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(obj);
    }

    private Object valueOf(String source) throws NumberFormatException {
        return this.type != Number.class ? Numbers.valueOf(source, this.type) : Numbers.narrowestNumber(source);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        source = source.strip();
        try {
            return this.valueOf(source);
        }
        catch (NumberFormatException cause) {
            throw new LocalizedParseException(null, this.type, source, null).initCause(cause);
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        Object value;
        int index;
        int end;
        boolean exponent = false;
        block6: for (end = index = CharSequences.skipLeadingWhitespaces(source, pos.getIndex(), source.length()); end < source.length(); ++end) {
            char c = source.charAt(end);
            switch (c) {
                default: {
                    if (c < '+' || c > '9') break block6;
                    continue block6;
                }
                case ',': 
                case '/': {
                    break block6;
                }
                case 'E': 
                case 'e': {
                    if (exponent) break block6;
                    exponent = true;
                    continue block6;
                }
            }
        }
        source = source.substring(index, end);
        try {
            value = this.valueOf(source);
        }
        catch (NumberFormatException cause) {
            pos.setErrorIndex(index);
            return null;
        }
        pos.setIndex(end);
        return value;
    }

    @Override
    public Object clone() {
        return this;
    }

    private Object readResolve() throws ObjectStreamException {
        Format format = DefaultFormat.getInstance(this.type);
        return format != null ? format : this;
    }
}

