/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.BinaryFunction;
import org.apache.sis.filter.base.Node;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.NumberType;
import org.opengis.util.ScopedName;

public abstract class BinaryFunctionWidening<R, A1, A2>
extends BinaryFunction<R, A1, A2> {
    private static final long serialVersionUID = -2515131813531876123L;

    protected BinaryFunctionWidening(Expression<R, ? extends A1> expression1, Expression<R, ? extends A2> expression2) {
        super(expression1, expression2);
    }

    protected final Expression<R, ? extends Number> specialize() {
        switch (BinaryFunctionWidening.effective(this.widestOperandType())) {
            case LONG: {
                return new Longs(this);
            }
            case DOUBLE: {
                return new Doubles(this);
            }
        }
        return null;
    }

    protected Class<? extends Number> getResultClass() {
        return Number.class;
    }

    private static NumberType getNumberType(Expression<?, ?> expression) {
        return NumberType.forClass(BinaryFunctionWidening.getResultClass(expression)).orElse(NumberType.NULL);
    }

    private static NumberType widest(NumberType t1, NumberType t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.isWiderThan(t2)) {
            if (t2 != NumberType.FLOAT || t1 == NumberType.BIG_DECIMAL) {
                return t1;
            }
        } else if (t2.isWiderThan(t1) && (t1 != NumberType.FLOAT || t2 == NumberType.BIG_DECIMAL)) {
            return t2;
        }
        return NumberType.NULL;
    }

    protected final NumberType widestOperandType() {
        return BinaryFunctionWidening.widest(BinaryFunctionWidening.getNumberType(this.expression1), BinaryFunctionWidening.getNumberType(this.expression2));
    }

    protected static NumberType effective(NumberType type) {
        switch (type) {
            case NULL: 
            case NUMBER: 
            case FRACTION: 
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                return type;
            }
            case LONG: 
            case BYTE: 
            case SHORT: 
            case INTEGER: {
                return NumberType.LONG;
            }
        }
        return NumberType.DOUBLE;
    }

    protected final Number apply(Number left, Number right) {
        NumberType type = BinaryFunctionWidening.widest(NumberType.forNumberClass(left.getClass()), NumberType.forNumberClass(right.getClass()));
        try {
            switch (type) {
                case FRACTION: {
                    return this.applyAsFraction((Fraction)type.cast(left), (Fraction)type.cast(right));
                }
                case BIG_INTEGER: {
                    return this.applyAsInteger((BigInteger)type.cast(left), (BigInteger)type.cast(right));
                }
                case BIG_DECIMAL: {
                    return this.applyAsDecimal((BigDecimal)type.cast(left), (BigDecimal)type.cast(right));
                }
                case LONG: 
                case BYTE: 
                case SHORT: 
                case INTEGER: {
                    return this.applyAsLong(left.longValue(), right.longValue());
                }
            }
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            this.warning(e, true);
        }
        return this.applyAsDouble(left instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)left).floatValue()) : left.doubleValue(), right instanceof Float ? DecimalFunctions.floatToDouble((float)((Float)right).floatValue()) : right.doubleValue());
    }

    protected abstract Number applyAsLong(long var1, long var3);

    protected abstract Number applyAsDouble(double var1, double var3);

    protected abstract Number applyAsFraction(Fraction var1, Fraction var2);

    protected abstract Number applyAsInteger(BigInteger var1, BigInteger var2);

    protected abstract Number applyAsDecimal(BigDecimal var1, BigDecimal var2);

    private static final class Longs<R>
    extends Specialization<R, Number> {
        private static final long serialVersionUID = 8799719407972742175L;

        Longs(BinaryFunctionWidening<R, ? extends Number, ? extends Number> delegate) {
            super(delegate);
        }

        @Override
        public Number apply(R feature) {
            Number right;
            Number left = (Number)this.delegate.expression1.apply(feature);
            if (left != null && (right = (Number)this.delegate.expression2.apply(feature)) != null) {
                try {
                    return this.delegate.applyAsLong(left.longValue(), right.longValue());
                }
                catch (ArithmeticException | IllegalArgumentException e) {
                    this.warning(e, true);
                    return this.delegate.applyAsDouble(left.doubleValue(), right.doubleValue());
                }
            }
            return null;
        }
    }

    private static final class Doubles<R>
    extends Specialization<R, Number> {
        private static final long serialVersionUID = -1962350161229383018L;

        Doubles(BinaryFunctionWidening<R, ? extends Number, ? extends Number> delegate) {
            super(delegate);
        }

        @Override
        public Number apply(R feature) {
            Number right;
            Number left = (Number)this.delegate.expression1.apply(feature);
            if (left != null && (right = (Number)this.delegate.expression2.apply(feature)) != null) {
                return this.delegate.applyAsDouble(left.doubleValue(), right.doubleValue());
            }
            return null;
        }
    }

    private static abstract class Specialization<R, A extends Number>
    extends Node
    implements FeatureExpression<R, Number>,
    Optimization.OnExpression<R, Number> {
        private static final long serialVersionUID = -6902891170861955149L;
        protected final BinaryFunctionWidening<R, ? extends A, ? extends A> delegate;

        protected Specialization(BinaryFunctionWidening<R, ? extends A, ? extends A> delegate) {
            this.delegate = delegate;
        }

        @Override
        public final ScopedName getFunctionName() {
            return ((Expression)((Object)this.delegate)).getFunctionName();
        }

        @Override
        public final Class<? super R> getResourceClass() {
            return this.delegate.getResourceClass();
        }

        @Override
        public final List<Expression<R, ?>> getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        protected final Collection<?> getChildren() {
            return this.delegate.getChildren();
        }

        @Override
        public final Class<? extends Number> getResultClass() {
            return this.delegate.getResultClass();
        }

        @Override
        public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
            return ((FeatureExpression)((Object)this.delegate)).expectedType(addTo);
        }

        @Override
        public final Expression<R, ? extends Number> optimize(Optimization optimization) {
            Expression result = ((Optimization.OnExpression)((Object)this.delegate)).optimize(optimization);
            if (result.getClass() == this.getClass() && ((Specialization)result).delegate == this.delegate) {
                return this;
            }
            return result;
        }
    }
}

