/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.StringTokenizer;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.generic.FieldOrMethod;
import org.aspectj.apache.bcel.generic.Type;

public class InvokeInstruction
extends FieldOrMethod {
    public InvokeInstruction(short s, int n) {
        super(s, n);
    }

    @Override
    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        StringTokenizer stringTokenizer = new StringTokenizer(constantPool.constantToString(constant));
        return Constants.OPCODE_NAMES[this.opcode] + " " + stringTokenizer.nextToken().replace('.', '/') + stringTokenizer.nextToken();
    }

    @Override
    public int consumeStack(ConstantPool constantPool) {
        String string = this.getSignature(constantPool);
        int n = Type.getArgumentSizes(string);
        if (this.opcode != 184) {
            ++n;
        }
        return n;
    }

    @Override
    public int produceStack(ConstantPool constantPool) {
        return this.getReturnType(constantPool).getSize();
    }

    @Override
    public Type getType(ConstantPool constantPool) {
        return this.getReturnType(constantPool);
    }

    public String getMethodName(ConstantPool constantPool) {
        return this.getName(constantPool);
    }

    public Type getReturnType(ConstantPool constantPool) {
        return Type.getReturnType(this.getSignature(constantPool));
    }

    public Type[] getArgumentTypes(ConstantPool constantPool) {
        return Type.getArgumentTypes(this.getSignature(constantPool));
    }
}

