/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type;

import java.util.Map;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.type.HistogramMetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.shade.io.prometheus.client.Histogram;

public final class PrometheusMetricsHistogramCollector
implements HistogramMetricsCollector {
    private static final String BUCKETS_KEY = "buckets";
    private static final String TYPE_KEY = "type";
    private static final String EXP_TYPE_KEY = "exp";
    private static final String LINEAR_TYPE_KEY = "linear";
    private static final String START_KEY = "start";
    private static final String COUNT_KEY = "count";
    private static final String FACTOR_KEY = "factor";
    private static final String WIDTH_KEY = "width";
    private final Histogram histogram;

    public PrometheusMetricsHistogramCollector(MetricConfiguration config) {
        Histogram.Builder builder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(config.getId())).help(config.getHelp())).labelNames(config.getLabels().toArray(new String[0]));
        this.appendProperties(builder, config.getProps());
        this.histogram = (Histogram)builder.register();
    }

    private void appendProperties(Histogram.Builder builder, Map<String, Object> props) {
        Map buckets = (Map)props.get(BUCKETS_KEY);
        if (null == buckets) {
            return;
        }
        if (EXP_TYPE_KEY.equals(buckets.get(TYPE_KEY))) {
            double start = null == buckets.get(START_KEY) ? 1.0 : Double.parseDouble(buckets.get(START_KEY).toString());
            double factor = null == buckets.get(FACTOR_KEY) ? 1.0 : Double.parseDouble(buckets.get(FACTOR_KEY).toString());
            int count = null == buckets.get(COUNT_KEY) ? 1 : (Integer)buckets.get(COUNT_KEY);
            builder.exponentialBuckets(start, factor, count);
        } else if (LINEAR_TYPE_KEY.equals(buckets.get(TYPE_KEY))) {
            double start = null == buckets.get(START_KEY) ? 1.0 : Double.parseDouble(buckets.get(START_KEY).toString());
            double width = null == buckets.get(WIDTH_KEY) ? 1.0 : Double.parseDouble(buckets.get(WIDTH_KEY).toString());
            int count = null == buckets.get(COUNT_KEY) ? 1 : (Integer)buckets.get(COUNT_KEY);
            builder.linearBuckets(start, width, count);
        }
    }

    @Override
    public void observe(double value) {
        this.histogram.observe(value);
    }
}

