/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.firebird.connector;

import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.jdbc.FBDriver;

public final class FirebirdConnectionPropertiesParser
implements ConnectionPropertiesParser {
    public ConnectionProperties parse(String url, String username, String catalog) {
        GDSType type = GDSFactory.getTypeForProtocol((String)url);
        String databaseURL = GDSFactory.getDatabasePath((GDSType)type, (String)url);
        DbAttachInfo dbAttachInfo = DbAttachInfo.parseConnectString((String)databaseURL);
        String attachObjectName = dbAttachInfo.getAttachObjectName();
        String databaseName = attachObjectName.contains("?") ? attachObjectName.split("\\?")[0] : attachObjectName;
        Properties queryProperties = new Properties();
        queryProperties.putAll((Map<?, ?>)FBDriver.normalizeProperties((String)url, (Properties)new Properties()));
        return new StandardConnectionProperties(dbAttachInfo.getServerName(), dbAttachInfo.getPortNumber(), databaseName, null, queryProperties, new Properties());
    }

    public String getDatabaseType() {
        return "Firebird";
    }
}

