/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sqlfederation.engine.SQLFederationEngine;
import org.apache.shardingsphere.sqlfederation.executor.context.SQLFederationContext;

public final class OpenGaussSystemCatalogAdminQueryExecutor
implements DatabaseAdminQueryExecutor {
    private static final String PG_CATALOG = "pg_catalog";
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final String databaseName;
    private final List<Object> parameters;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession) throws SQLException {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), connectionSession.getConnectionContext());
        try (SQLFederationEngine sqlFederationEngine = new SQLFederationEngine(this.databaseName, PG_CATALOG, metaDataContexts.getMetaData(), metaDataContexts.getStatistics(), jdbcExecutor);){
            DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(metaDataContexts, connectionSession);
            SQLFederationContext context = new SQLFederationContext(false, new QueryContext(this.sqlStatementContext, this.sql, this.parameters, SQLHintUtils.extractHint((String)this.sql), connectionSession.getConnectionContext(), metaDataContexts.getMetaData()), metaDataContexts.getMetaData(), connectionSession.getProcessId());
            ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(this.databaseName);
            ResultSet resultSet = sqlFederationEngine.executeQuery(prepareEngine, this.createOpenGaussSystemCatalogAdminQueryCallback(database.getProtocolType(), database.getResourceMetaData(), this.sqlStatementContext.getSqlStatement()), context);
            this.queryResultMetaData = new JDBCQueryResultMetaData(resultSet.getMetaData());
            this.mergedResult = new IteratorStreamMergedResult(Collections.singletonList(new JDBCMemoryQueryResult(resultSet, connectionSession.getProtocolType())));
        }
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(MetaDataContexts metaDataContexts, ConnectionSession connectionSession) {
        int maxConnectionsSizePerQuery = (Integer)metaDataContexts.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (DatabaseConnectionManager)connectionSession.getDatabaseConnectionManager(), connectionSession.getStatementManager(), (StorageResourceOption)new StatementOption(false), metaDataContexts.getMetaData().getDatabase(this.databaseName).getRuleMetaData().getRules(), metaDataContexts.getMetaData().getDatabase(this.databaseName).getResourceMetaData().getStorageUnits());
    }

    private JDBCExecutorCallback<ExecuteResult> createOpenGaussSystemCatalogAdminQueryCallback(DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement) {
        return new JDBCExecutorCallback<ExecuteResult>(protocolType, resourceMetaData, sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return new JDBCStreamQueryResult(statement.executeQuery(sql));
            }

            protected Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Generated
    public OpenGaussSystemCatalogAdminQueryExecutor(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.databaseName = databaseName;
        this.parameters = parameters;
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

