/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.h2.connector;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;

public final class H2ConnectionProperties
implements ConnectionProperties {
    private static final String MODEL_MEM = "mem";
    private static final String MODEL_PWD = "~";
    private static final String MODEL_FILE = "file:";
    private final String hostname;
    private final String model;
    private final int port;
    private final String catalog;

    public String getSchema() {
        return null;
    }

    public Properties getQueryProperties() {
        return new Properties();
    }

    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    public boolean isInSameDatabaseInstance(ConnectionProperties connectionProps) {
        if (!(connectionProps instanceof H2ConnectionProperties)) {
            return false;
        }
        if (!this.isSameModel(this.getModel(), ((H2ConnectionProperties)connectionProps).getModel())) {
            return false;
        }
        return this.hostname.equals(connectionProps.getHostname()) && this.port == connectionProps.getPort();
    }

    private boolean isSameModel(String model1, String model2) {
        if (MODEL_MEM.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_PWD.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_FILE.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2);
        }
        return model1.equalsIgnoreCase(model2);
    }

    @Generated
    public H2ConnectionProperties(String hostname, String model, int port, String catalog) {
        this.hostname = hostname;
        this.model = model;
        this.port = port;
        this.catalog = catalog;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }
}

