/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineSchemaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineSchemaUtils.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getDefaultSchema(PipelineDataSourceConfiguration dataSourceConfig) {
        try (PipelineDataSource dataSource = new PipelineDataSource(dataSourceConfig);){
            String string;
            block13: {
                Connection connection = dataSource.getConnection();
                try {
                    String result = connection.getSchema();
                    log.info("get default schema {}", (Object)result);
                    string = result;
                    if (connection == null) break block13;
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                connection.close();
            }
            return string;
        }
    }

    @Generated
    private PipelineSchemaUtils() {
    }
}

