/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.node.path.metadata.StatesNodePath;
import org.apache.shardingsphere.mode.state.ClusterState;

public final class ClusterStateChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return StatesNodePath.getClusterStatePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        contextManager.getStateContext().switchState(this.getClusterState(event));
    }

    private ClusterState getClusterState(DataChangedEvent event) {
        try {
            return ClusterState.valueOf((String)event.getValue());
        }
        catch (IllegalArgumentException ignore) {
            return ClusterState.OK;
        }
    }
}

