/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.netty.ServerHandlerInitializer;
import org.apache.shardingsphere.proxy.frontend.protocol.FrontDatabaseProtocolTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereProxy.class);
    private final EventLoopGroup bossGroup = Epoll.isAvailable() ? new EpollEventLoopGroup(1) : new NioEventLoopGroup(1);
    private final EventLoopGroup workerGroup = this.getWorkerGroup();
    private boolean isClosed;

    public ShardingSphereProxy() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    private EventLoopGroup getWorkerGroup() {
        int workerThreads = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_EXECUTOR_SIZE);
        return Epoll.isAvailable() ? new EpollEventLoopGroup(workerThreads) : new NioEventLoopGroup(workerThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port, List<String> addresses) {
        try {
            List<ChannelFuture> futures = this.startInternal(port, addresses);
            this.accept(futures);
        }
        finally {
            this.close();
        }
    }

    public void start(String socketPath) {
        if (!Epoll.isAvailable()) {
            log.error("Epoll is unavailable, DomainSocket can't start.");
            return;
        }
        ChannelFuture future = this.startDomainSocket(socketPath);
        future.addListener((GenericFutureListener)((ChannelFutureListener)futureParams -> {
            if (futureParams.isSuccess()) {
                log.info("The listening address for DomainSocket is {}", (Object)socketPath);
            } else {
                log.error("DomainSocket failed to start:{}", (Object)futureParams.cause().getMessage());
            }
        }));
    }

    public List<ChannelFuture> startInternal(int port, List<String> addresses) throws InterruptedException {
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.initServerBootstrap(bootstrap);
        ArrayList<ChannelFuture> result = new ArrayList<ChannelFuture>(addresses.size());
        for (String each : addresses) {
            result.add(bootstrap.bind(each, port).sync());
        }
        return result;
    }

    private ChannelFuture startDomainSocket(String socketPath) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        this.initServerBootstrap(bootstrap, new DomainSocketAddress(socketPath));
        return bootstrap.bind();
    }

    private void accept(List<ChannelFuture> futures) throws InterruptedException {
        log.info("ShardingSphere-Proxy {} mode started successfully", (Object)ProxyContext.getInstance().getContextManager().getComputeNodeInstanceContext().getModeConfiguration().getType());
        for (ChannelFuture each : futures) {
            each.channel().closeFuture().sync();
        }
    }

    private void initServerBootstrap(ServerBootstrap bootstrap) {
        Integer backLog = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_NETTY_BACKLOG);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)backLog)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer(FrontDatabaseProtocolTypeFactory.getDatabaseType()));
    }

    private void initServerBootstrap(ServerBootstrap bootstrap, DomainSocketAddress localDomainSocketAddress) {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(EpollServerDomainSocketChannel.class)).localAddress((SocketAddress)localDomainSocketAddress)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer(FrontDatabaseProtocolTypeFactory.getDatabaseType()));
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        BackendExecutorContext.getInstance().getExecutorEngine().close();
        ProxyContext.getInstance().getContextManager().close();
        this.isClosed = true;
    }
}

