/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.keygen.uuid;

import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.shardingsphere.infra.algorithm.core.context.AlgorithmSQLContext;
import org.apache.shardingsphere.infra.algorithm.keygen.core.KeyGenerateAlgorithm;

public final class UUIDKeyGenerateAlgorithm
implements KeyGenerateAlgorithm {
    public Collection<String> generateKeys(AlgorithmSQLContext context, int keyGenerateCount) {
        LinkedList<String> result = new LinkedList<String>();
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        for (int index = 0; index < keyGenerateCount; ++index) {
            result.add(this.generateKey(threadLocalRandom));
        }
        return result;
    }

    private String generateKey(ThreadLocalRandom threadLocalRandom) {
        return new UUID(threadLocalRandom.nextLong(), threadLocalRandom.nextLong()).toString().replace("-", "");
    }

    public String getType() {
        return "UUID";
    }
}

