/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.tables;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereTableDataCollectorUtils;

public final class PgClassTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String PG_CLASS = "pg_class";
    private static final String PUBLIC_SCHEMA = "public";
    private static final Long PUBLIC_SCHEMA_OID = 0L;

    @Override
    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, ShardingSphereMetaData metaData) throws SQLException {
        ShardingSphereTableData result = new ShardingSphereTableData(PG_CLASS);
        ShardingSphereSchema publicSchema = metaData.getDatabase(databaseName).getSchema(PUBLIC_SCHEMA);
        if (null != publicSchema) {
            result.getRows().addAll(this.collectForSchema(0L, PUBLIC_SCHEMA_OID, publicSchema, table));
        }
        return Optional.of(result);
    }

    private Collection<ShardingSphereRowData> collectForSchema(Long oid, Long relNamespace, ShardingSphereSchema schema, ShardingSphereTable table) {
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        for (ShardingSphereTable each : schema.getAllTables()) {
            CaseInsensitiveMap columnValues = new CaseInsensitiveMap(4, 1.0f);
            columnValues.put("oid", oid);
            columnValues.put("relnamespace", relNamespace);
            columnValues.put("relname", each.getName());
            columnValues.put("relkind", "r");
            result.add(new ShardingSphereRowData(ShardingSphereTableDataCollectorUtils.createRowValue((Map<String, Object>)columnValues, table)));
        }
        return result;
    }

    public String getType() {
        return PG_CLASS;
    }
}

