/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.shardingsphere.driver.exception.DriverRegisterException;
import org.apache.shardingsphere.driver.jdbc.core.driver.DriverDataSourceCache;

public final class ShardingSphereDriver
implements Driver {
    private static final String DRIVER_URL_PREFIX = "jdbc:shardingsphere:";
    private static final int MAJOR_DRIVER_VERSION = 5;
    private static final int MINOR_DRIVER_VERSION = 5;
    private final DriverDataSourceCache dataSourceCache = new DriverDataSourceCache();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? this.dataSourceCache.get(url, DRIVER_URL_PREFIX).getConnection() : null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return null != url && url.startsWith(DRIVER_URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 5;
    }

    @Override
    public int getMinorVersion() {
        return 5;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    static {
        try {
            DriverManager.registerDriver(new ShardingSphereDriver());
        }
        catch (SQLException ex) {
            throw new DriverRegisterException(ex);
        }
    }
}

