/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.management;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinlogEventType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.AbstractMySQLBinlogEventPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.MySQLBinlogEventHeader;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinlogFormatDescriptionEventPacket
extends AbstractMySQLBinlogEventPacket {
    private final int binlogVersion = 4;
    private final byte[] mysqlServerVersion;
    private final int createTimestamp;
    private final int eventHeaderLength = 19;

    public MySQLBinlogFormatDescriptionEventPacket(MySQLBinlogEventHeader binlogEventHeader, MySQLPacketPayload payload) {
        super(binlogEventHeader);
        Preconditions.checkArgument((4 == payload.readInt2() ? 1 : 0) != 0, (Object)"Binlog version of FORMAT_DESCRIPTION_EVENT should always 4");
        this.mysqlServerVersion = payload.readStringFixByBytes(50);
        this.createTimestamp = payload.readInt4();
        Preconditions.checkArgument((19 == payload.readInt1() ? 1 : 0) != 0, (Object)"Length of the Binlog Event Header should always be 19.");
        this.skipTypeHeaderLength(payload);
        this.skipCheckSums(payload);
    }

    private void skipTypeHeaderLength(MySQLPacketPayload payload) {
        payload.skipReserved(MySQLBinlogEventType.FORMAT_DESCRIPTION_EVENT.getValue() - 1);
        int eventLength = payload.readInt1();
        int remainLength = eventLength - 2 - 50 - 4 - 1 - (MySQLBinlogEventType.FORMAT_DESCRIPTION_EVENT.getValue() - 1) - 1;
        payload.skipReserved(remainLength);
    }

    private void skipCheckSums(MySQLPacketPayload payload) {
        int checksumAlgorithmFlag = payload.readInt1();
        if (1 == checksumAlgorithmFlag) {
            payload.skipReserved(4);
        }
    }

    @Override
    protected void writeEvent(MySQLPacketPayload payload) {
    }

    @Generated
    public int getBinlogVersion() {
        return this.binlogVersion;
    }

    @Generated
    public byte[] getMysqlServerVersion() {
        return this.mysqlServerVersion;
    }

    @Generated
    public int getCreateTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public int getEventHeaderLength() {
        return this.eventHeaderLength;
    }

    @Generated
    public String toString() {
        return "MySQLBinlogFormatDescriptionEventPacket(binlogVersion=" + this.getBinlogVersion() + ", mysqlServerVersion=" + Arrays.toString(this.getMysqlServerVersion()) + ", createTimestamp=" + this.getCreateTimestamp() + ", eventHeaderLength=" + this.getEventHeaderLength() + ")";
    }
}

