/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.listener;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.exception.TracingConfigurationException;
import org.apache.shardingsphere.elasticjob.tracing.listener.TracingListener;
import org.apache.shardingsphere.elasticjob.tracing.listener.TracingListenerConfiguration;

public final class TracingListenerFactory {
    private static final Map<String, TracingListenerConfiguration> LISTENER_CONFIGS = new HashMap<String, TracingListenerConfiguration>();

    public static TracingListener getListener(TracingConfiguration tracingConfig) throws TracingConfigurationException {
        if (null == tracingConfig.getTracingStorageConfiguration() || Strings.isNullOrEmpty((String)tracingConfig.getType()) || !LISTENER_CONFIGS.containsKey(tracingConfig.getType())) {
            throw new TracingConfigurationException(String.format("Can not find executor service handler type '%s'.", tracingConfig.getType()));
        }
        return LISTENER_CONFIGS.get(tracingConfig.getType()).createTracingListener(tracingConfig.getTracingStorageConfiguration().getStorage());
    }

    @Generated
    private TracingListenerFactory() {
    }

    static {
        for (TracingListenerConfiguration each : ServiceLoader.load(TracingListenerConfiguration.class)) {
            LISTENER_CONFIGS.put(each.getType(), each);
        }
    }
}

